/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.slice.SizeOf;
import java.util.Objects;

public final class CatalogName {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CatalogName.class);
    private final String catalogName;

    @JsonCreator
    public CatalogName(String catalogName) {
        if (catalogName.isEmpty()) {
            throw new IllegalArgumentException("catalogName is empty");
        }
        this.catalogName = catalogName;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.catalogName);
    }

    @JsonValue
    public String toString() {
        return this.catalogName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof CatalogName)) return false;
        CatalogName other = (CatalogName)o;
        if (!this.catalogName.equals(other.catalogName)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName);
    }
}

