/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.context.Context;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.HttpConstants;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.ForwardedHostAddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.ForwardedUrlSchemeProvider;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerAddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.ClientAddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalClientAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.network.internal.InternalServerAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.url.internal.InternalUrlAttributesExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public final class HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final AddressAndPortExtractor<REQUEST> clientAddressPortExtractor;
    final AddressAndPortExtractor<REQUEST> serverAddressPortExtractor;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;
    Function<Context, String> httpRouteGetter = HttpServerRoute::get;

    HttpServerAttributesExtractorBuilder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.clientAddressPortExtractor = new ClientAddressAndPortExtractor<REQUEST>(httpAttributesGetter, new HttpServerAddressAndPortExtractor<REQUEST>(httpAttributesGetter));
        this.serverAddressPortExtractor = new ForwardedHostAddressAndPortExtractor<REQUEST>(httpAttributesGetter);
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = new ArrayList<String>(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = new ArrayList<String>(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> setHttpRouteGetter(Function<Context, String> httpRouteGetter) {
        this.httpRouteGetter = httpRouteGetter;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpServerAttributesExtractor(this);
    }

    InternalUrlAttributesExtractor<REQUEST> buildUrlExtractor() {
        return new InternalUrlAttributesExtractor(this.httpAttributesGetter, new ForwardedUrlSchemeProvider<REQUEST>(this.httpAttributesGetter));
    }

    InternalNetworkAttributesExtractor<REQUEST, RESPONSE> buildNetworkExtractor() {
        return new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(this.httpAttributesGetter, false, false);
    }

    InternalServerAttributesExtractor<REQUEST> buildServerExtractor() {
        return new InternalServerAttributesExtractor<REQUEST>(this.serverAddressPortExtractor);
    }

    InternalClientAttributesExtractor<REQUEST> buildClientExtractor() {
        return new InternalClientAttributesExtractor<REQUEST>(this.clientAddressPortExtractor, false);
    }
}

