/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterWrapper;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.ipc.CallerDisconnectedException;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReadPointCalculationLock;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Shipper;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionScannerImpl
implements RegionScanner,
Shipper,
RpcCallback {
    private static final Logger LOG = LoggerFactory.getLogger(RegionScannerImpl.class);
    KeyValueHeap storeHeap = null;
    KeyValueHeap joinedHeap = null;
    protected Cell joinedContinuationRow = null;
    private boolean filterClosed = false;
    protected final byte[] stopRow;
    protected final boolean includeStopRow;
    protected final HRegion region;
    protected final CellComparator comparator;
    private final ConcurrentHashMap<RegionScanner, Long> scannerReadPoints;
    private final long readPt;
    private final long maxResultSize;
    private final ScannerContext defaultScannerContext;
    private final FilterWrapper filter;
    private final String operationId;
    private RegionServerServices rsServices;
    private static final List<Cell> MOCKED_LIST = new AbstractList<Cell>(){

        @Override
        public void add(int index, Cell element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends Cell> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    public RegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    private static boolean hasNonce(HRegion region, long nonce) {
        RegionServerServices rsServices = region.getRegionServerServices();
        return nonce != 0L && rsServices != null && rsServices.getNonceManager() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region, long nonceGroup, long nonce) throws IOException {
        this.region = region;
        this.maxResultSize = scan.getMaxResultSize();
        this.filter = scan.hasFilter() ? new FilterWrapper(scan.getFilter()) : null;
        this.comparator = region.getCellComparator();
        this.defaultScannerContext = ScannerContext.newBuilder().setBatchLimit(scan.getBatch()).build();
        this.stopRow = scan.getStopRow();
        this.includeStopRow = scan.includeStopRow();
        this.operationId = scan.getId();
        IsolationLevel isolationLevel = scan.getIsolationLevel();
        long mvccReadPoint = PackagePrivateFieldAccessor.getMvccReadPoint((Scan)scan);
        this.scannerReadPoints = region.scannerReadPoints;
        this.rsServices = region.getRegionServerServices();
        region.smallestReadPointCalcLock.lock(ReadPointCalculationLock.LockType.RECORDING_LOCK);
        try {
            this.readPt = mvccReadPoint > 0L ? mvccReadPoint : (RegionScannerImpl.hasNonce(region, nonce) ? this.rsServices.getNonceManager().getMvccFromOperationContext(nonceGroup, nonce) : region.getReadPoint(isolationLevel));
            this.scannerReadPoints.put(this, this.readPt);
        }
        finally {
            region.smallestReadPointCalcLock.unlock(ReadPointCalculationLock.LockType.RECORDING_LOCK);
        }
        this.initializeScanners(scan, additionalScanners);
    }

    private void initializeScanners(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(scan.getFamilyMap().size());
        ArrayList<KeyValueScanner> joinedScanners = new ArrayList<KeyValueScanner>(scan.getFamilyMap().size());
        ArrayList<KeyValueScanner> instantiatedScanners = new ArrayList<KeyValueScanner>();
        if (additionalScanners != null && !additionalScanners.isEmpty()) {
            scanners.addAll(additionalScanners);
            instantiatedScanners.addAll(additionalScanners);
        }
        try {
            for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
                HStore store = this.region.getStore((byte[])entry.getKey());
                KeyValueScanner scanner = store.getScanner(scan, (NavigableSet)entry.getValue(), this.readPt);
                instantiatedScanners.add(scanner);
                if (this.filter == null || !scan.doLoadColumnFamiliesOnDemand() || this.filter.isFamilyEssential((byte[])entry.getKey())) {
                    scanners.add(scanner);
                    continue;
                }
                joinedScanners.add(scanner);
            }
            this.initializeKVHeap(scanners, joinedScanners, this.region);
        }
        catch (Throwable t) {
            throw this.handleException(instantiatedScanners, t);
        }
    }

    protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
        this.storeHeap = new KeyValueHeap(scanners, this.comparator);
        if (!joinedScanners.isEmpty()) {
            this.joinedHeap = new KeyValueHeap(joinedScanners, this.comparator);
        }
    }

    private IOException handleException(List<KeyValueScanner> instantiatedScanners, Throwable t) {
        this.scannerReadPoints.remove(this);
        if (this.storeHeap != null) {
            this.storeHeap.close();
            this.storeHeap = null;
            if (this.joinedHeap != null) {
                this.joinedHeap.close();
                this.joinedHeap = null;
            }
        } else {
            for (KeyValueScanner scanner : instantiatedScanners) {
                scanner.close();
            }
        }
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    @Override
    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    @Override
    public long getMvccReadPoint() {
        return this.readPt;
    }

    @Override
    public int getBatch() {
        return this.defaultScannerContext.getBatchLimit();
    }

    @Override
    public String getOperationId() {
        return this.operationId;
    }

    protected final void resetFilters() throws IOException {
        if (this.filter != null) {
            this.filter.reset();
        }
    }

    @Override
    public boolean next(List<Cell> outResults) throws IOException {
        return this.next(outResults, this.defaultScannerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean next(List<Cell> outResults, ScannerContext scannerContext) throws IOException {
        if (this.filterClosed) {
            throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
        }
        this.region.startRegionOperation(Region.Operation.SCAN);
        try {
            boolean bl = this.nextRaw(outResults, scannerContext);
            return bl;
        }
        finally {
            this.region.closeRegionOperation(Region.Operation.SCAN);
        }
    }

    @Override
    public boolean nextRaw(List<Cell> outResults) throws IOException {
        return this.nextRaw(outResults, this.defaultScannerContext);
    }

    @Override
    public boolean nextRaw(List<Cell> outResults, ScannerContext scannerContext) throws IOException {
        if (this.storeHeap == null) {
            throw new UnknownScannerException("Scanner was closed");
        }
        boolean moreValues = false;
        if (outResults.isEmpty()) {
            moreValues = this.nextInternal(outResults, scannerContext);
        } else {
            ArrayList<Cell> tmpList = new ArrayList<Cell>();
            moreValues = this.nextInternal(tmpList, scannerContext);
            outResults.addAll(tmpList);
        }
        this.region.addReadRequestsCount(1L);
        if (this.region.getMetrics() != null) {
            this.region.getMetrics().updateReadRequestCount();
        }
        if (!scannerContext.mayHaveMoreCellsInRow()) {
            this.resetFilters();
        }
        if (this.isFilterDoneInternal()) {
            moreValues = false;
        }
        return moreValues;
    }

    private boolean populateFromJoinedHeap(List<Cell> results, ScannerContext scannerContext) throws IOException {
        assert (this.joinedContinuationRow != null);
        boolean moreValues = this.populateResult(results, this.joinedHeap, scannerContext, this.joinedContinuationRow);
        if (!scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
            this.joinedContinuationRow = null;
        }
        results.sort((Comparator<Cell>)this.comparator);
        return moreValues;
    }

    private boolean populateResult(List<Cell> results, KeyValueHeap heap, ScannerContext scannerContext, Cell currentRowCell) throws IOException {
        Cell nextKv;
        boolean moreCellsInRow = false;
        boolean tmpKeepProgress = scannerContext.getKeepProgress();
        ScannerContext.LimitScope limitScope = ScannerContext.LimitScope.BETWEEN_CELLS;
        do {
            this.region.checkInterrupt();
            scannerContext.setKeepProgress(true);
            heap.next(results, scannerContext);
            scannerContext.setKeepProgress(tmpKeepProgress);
            nextKv = heap.peek();
            moreCellsInRow = this.moreCellsInRow(nextKv, currentRowCell);
            if (!moreCellsInRow) {
                this.incrementCountOfRowsScannedMetric(scannerContext);
            }
            if (moreCellsInRow && scannerContext.checkBatchLimit(limitScope)) {
                return scannerContext.setScannerState(ScannerContext.NextState.BATCH_LIMIT_REACHED).hasMoreValues();
            }
            if (scannerContext.checkSizeLimit(limitScope)) {
                ScannerContext.NextState state = moreCellsInRow ? ScannerContext.NextState.SIZE_LIMIT_REACHED_MID_ROW : ScannerContext.NextState.SIZE_LIMIT_REACHED;
                return scannerContext.setScannerState(state).hasMoreValues();
            }
            if (!scannerContext.checkTimeLimit(limitScope)) continue;
            ScannerContext.NextState state = moreCellsInRow ? ScannerContext.NextState.TIME_LIMIT_REACHED_MID_ROW : ScannerContext.NextState.TIME_LIMIT_REACHED;
            return scannerContext.setScannerState(state).hasMoreValues();
        } while (moreCellsInRow);
        return nextKv != null;
    }

    private boolean moreCellsInRow(Cell nextKv, Cell currentRowCell) {
        return nextKv != null && CellUtil.matchingRows((Cell)nextKv, (Cell)currentRowCell);
    }

    @Override
    public synchronized boolean isFilterDone() throws IOException {
        return this.isFilterDoneInternal();
    }

    private boolean isFilterDoneInternal() throws IOException {
        return this.filter != null && this.filter.filterAllRemaining();
    }

    private void checkClientDisconnect(Optional<RpcCall> rpcCall) throws CallerDisconnectedException {
        long afterTime;
        if (rpcCall.isPresent() && (afterTime = rpcCall.get().disconnectSince()) >= 0L) {
            throw new CallerDisconnectedException("Aborting on region " + this.getRegionInfo().getRegionNameAsString() + ", call " + this + " after " + afterTime + " ms, since caller disconnected");
        }
    }

    private void resetProgress(ScannerContext scannerContext, int initialBatchProgress, long initialSizeProgress, long initialHeapSizeProgress) {
        if (scannerContext.getKeepProgress()) {
            scannerContext.setProgress(initialBatchProgress, initialSizeProgress, initialHeapSizeProgress);
        } else {
            scannerContext.clearProgress();
        }
    }

    private boolean nextInternal(List<Cell> results, ScannerContext scannerContext) throws IOException {
        boolean shouldStop;
        block27: {
            Preconditions.checkArgument((boolean)results.isEmpty(), (Object)"First parameter should be an empty list");
            Preconditions.checkArgument((scannerContext != null ? 1 : 0) != 0, (Object)"Scanner context cannot be null");
            Optional<RpcCall> rpcCall = RpcServer.getCurrentCall();
            int initialBatchProgress = scannerContext.getBatchProgress();
            long initialSizeProgress = scannerContext.getDataSizeProgress();
            long initialHeapSizeProgress = scannerContext.getHeapSizeProgress();
            ScannerContext.LimitScope limitScope = ScannerContext.LimitScope.BETWEEN_CELLS;
            while (true) {
                boolean hasFilterRow;
                this.resetProgress(scannerContext, initialBatchProgress, initialSizeProgress, initialHeapSizeProgress);
                this.checkClientDisconnect(rpcCall);
                this.region.checkInterrupt();
                Cell current = this.storeHeap.peek();
                shouldStop = this.shouldStop(current);
                boolean bl = hasFilterRow = this.filter != null && this.filter.hasFilterRow();
                if (hasFilterRow) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("filter#hasFilterRow is true which prevents partial results from being  formed. Changing scope of limits that may create partials");
                    }
                    scannerContext.setSizeLimitScope(ScannerContext.LimitScope.BETWEEN_ROWS);
                    scannerContext.setTimeLimitScope(ScannerContext.LimitScope.BETWEEN_ROWS);
                    limitScope = ScannerContext.LimitScope.BETWEEN_ROWS;
                }
                if (scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                    if (hasFilterRow) {
                        throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scans that must  stop mid-row because of a limit. ScannerContext:" + scannerContext);
                    }
                    return true;
                }
                if (this.joinedContinuationRow == null) {
                    boolean mayHaveData;
                    if (shouldStop) {
                        if (hasFilterRow) {
                            this.filter.filterRowCells(results);
                        }
                        return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                    }
                    if (this.filterRowKey(current)) {
                        this.incrementCountOfRowsFilteredMetric(scannerContext);
                        if (this.isFilterDoneInternal()) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        this.incrementCountOfRowsScannedMetric(scannerContext);
                        boolean moreRows = this.nextRow(scannerContext, current);
                        if (!moreRows) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        results.clear();
                        if (!scannerContext.checkAnyLimitReached(limitScope)) continue;
                        return true;
                    }
                    this.populateResult(results, this.storeHeap, scannerContext, current);
                    if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        if (hasFilterRow) {
                            throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scans that must  stop mid-row because of a limit. ScannerContext:" + scannerContext);
                        }
                        return true;
                    }
                    this.region.checkInterrupt();
                    Cell nextKv = this.storeHeap.peek();
                    shouldStop = this.shouldStop(nextKv);
                    boolean isEmptyRow = results.isEmpty();
                    FilterWrapper.FilterRowRetCode ret = FilterWrapper.FilterRowRetCode.NOT_CALLED;
                    if (hasFilterRow) {
                        ret = this.filter.filterRowCellsWithRet(results);
                        if (scannerContext.getKeepProgress()) {
                            scannerContext.setProgress(initialBatchProgress, initialSizeProgress, initialHeapSizeProgress);
                        } else {
                            scannerContext.clearProgress();
                        }
                        scannerContext.incrementBatchProgress(results.size());
                        for (Cell cell : results) {
                            scannerContext.incrementSizeProgress(PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell), cell.heapSize());
                        }
                    }
                    if (isEmptyRow || ret == FilterWrapper.FilterRowRetCode.EXCLUDE || this.filterRow()) {
                        this.incrementCountOfRowsFilteredMetric(scannerContext);
                        results.clear();
                        boolean moreRows = this.nextRow(scannerContext, current);
                        if (!moreRows) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        if (!shouldStop) {
                            if (!scannerContext.checkAnyLimitReached(limitScope)) continue;
                            return true;
                        }
                        return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                    }
                    if (this.joinedHeap != null && (mayHaveData = this.joinedHeapMayHaveData(current))) {
                        this.joinedContinuationRow = current;
                        this.populateFromJoinedHeap(results, scannerContext);
                        if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                            return true;
                        }
                    }
                } else {
                    this.populateFromJoinedHeap(results, scannerContext);
                    if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        return true;
                    }
                }
                if (this.joinedContinuationRow != null) {
                    return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                }
                if (!results.isEmpty()) break block27;
                this.incrementCountOfRowsFilteredMetric(scannerContext);
                boolean moreRows = this.nextRow(scannerContext, current);
                if (!moreRows) {
                    return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                }
                if (shouldStop) break block27;
                if (scannerContext.checkSizeLimit(limitScope)) break;
            }
            return true;
        }
        if (shouldStop) {
            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
    }

    private void incrementCountOfRowsFilteredMetric(ScannerContext scannerContext) {
        this.region.filteredReadRequestsCount.increment();
        if (this.region.getMetrics() != null) {
            this.region.getMetrics().updateFilteredRecords();
        }
        if (scannerContext == null || !scannerContext.isTrackingMetrics()) {
            return;
        }
        scannerContext.getMetrics().countOfRowsFiltered.incrementAndGet();
    }

    private void incrementCountOfRowsScannedMetric(ScannerContext scannerContext) {
        if (scannerContext == null || !scannerContext.isTrackingMetrics()) {
            return;
        }
        scannerContext.getMetrics().countOfRowsScanned.incrementAndGet();
    }

    private boolean joinedHeapMayHaveData(Cell currentRowCell) throws IOException {
        Cell nextJoinedKv = this.joinedHeap.peek();
        boolean matchCurrentRow = nextJoinedKv != null && CellUtil.matchingRows((Cell)nextJoinedKv, (Cell)currentRowCell);
        boolean matchAfterSeek = false;
        if (!matchCurrentRow) {
            Cell firstOnCurrentRow = PrivateCellUtil.createFirstOnRow((Cell)currentRowCell);
            boolean seekSuccessful = this.joinedHeap.requestSeek(firstOnCurrentRow, true, true);
            matchAfterSeek = seekSuccessful && this.joinedHeap.peek() != null && CellUtil.matchingRows((Cell)this.joinedHeap.peek(), (Cell)currentRowCell);
        }
        return matchCurrentRow || matchAfterSeek;
    }

    private boolean filterRow() throws IOException {
        return this.filter != null && !this.filter.hasFilterRow() && this.filter.filterRow();
    }

    private boolean filterRowKey(Cell current) throws IOException {
        return this.filter != null && this.filter.filterRowKey(current);
    }

    protected boolean nextRow(ScannerContext scannerContext, Cell curRowCell) throws IOException {
        Cell next;
        assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
        scannerContext.setSkippingRow(true);
        while ((next = this.storeHeap.peek()) != null && CellUtil.matchingRows((Cell)next, (Cell)curRowCell)) {
            this.region.checkInterrupt();
            this.storeHeap.next(MOCKED_LIST, scannerContext);
        }
        scannerContext.setSkippingRow(false);
        this.resetFilters();
        return this.region.getCoprocessorHost() == null || this.region.getCoprocessorHost().postScannerFilterRow(this, curRowCell);
    }

    protected boolean shouldStop(Cell currentRowCell) {
        if (currentRowCell == null) {
            return true;
        }
        if (this.stopRow == null || Bytes.equals((byte[])this.stopRow, (byte[])HConstants.EMPTY_END_ROW)) {
            return false;
        }
        int c = this.comparator.compareRows(currentRowCell, this.stopRow, 0, this.stopRow.length);
        return c > 0 || c == 0 && !this.includeStopRow;
    }

    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="this method is only called inside close which is synchronized")
    private void closeInternal() {
        if (this.storeHeap != null) {
            this.storeHeap.close();
            this.storeHeap = null;
        }
        if (this.joinedHeap != null) {
            this.joinedHeap.close();
            this.joinedHeap = null;
        }
        this.scannerReadPoints.remove(this);
        this.filterClosed = true;
    }

    @Override
    public synchronized void close() {
        TraceUtil.trace(this::closeInternal, () -> this.region.createRegionSpan("RegionScanner.close"));
    }

    @Override
    public synchronized boolean reseek(byte[] row) throws IOException {
        return (Boolean)TraceUtil.trace(() -> {
            if (row == null) {
                throw new IllegalArgumentException("Row cannot be null.");
            }
            boolean result = false;
            this.region.startRegionOperation();
            Cell kv = PrivateCellUtil.createFirstOnRow((byte[])row, (int)0, (short)((short)row.length));
            try {
                result = this.storeHeap.requestSeek(kv, true, true);
                if (this.joinedHeap != null) {
                    result = this.joinedHeap.requestSeek(kv, true, true) || result;
                }
            }
            finally {
                this.region.closeRegionOperation();
            }
            return result;
        }, () -> this.region.createRegionSpan("RegionScanner.reseek"));
    }

    @Override
    public void shipped() throws IOException {
        if (this.storeHeap != null) {
            this.storeHeap.shipped();
        }
        if (this.joinedHeap != null) {
            this.joinedHeap.shipped();
        }
    }

    @Override
    public void run() throws IOException {
        this.close();
    }
}

