/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.KeyManagerException;
import org.apache.hadoop.hbase.exceptions.SSLContextException;
import org.apache.hadoop.hbase.exceptions.TrustManagerException;
import org.apache.hadoop.hbase.exceptions.X509Exception;
import org.apache.hadoop.hbase.io.FileChangeWatcher;
import org.apache.hadoop.hbase.io.crypto.tls.FileKeyStoreLoaderBuilderProvider;
import org.apache.hadoop.hbase.io.crypto.tls.HBaseTrustManager;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hbase.thirdparty.com.google.common.collect.ObjectArrays;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.OpenSsl;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class X509Util {
    private static final Logger LOG = LoggerFactory.getLogger(X509Util.class);
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    static final String CONFIG_PREFIX = "hbase.rpc.tls.";
    public static final String TLS_CONFIG_PROTOCOL = "hbase.rpc.tls.protocol";
    public static final String TLS_CONFIG_KEYSTORE_LOCATION = "hbase.rpc.tls.keystore.location";
    public static final String TLS_CONFIG_KEYSTORE_TYPE = "hbase.rpc.tls.keystore.type";
    public static final String TLS_CONFIG_KEYSTORE_PASSWORD = "hbase.rpc.tls.keystore.password";
    public static final String TLS_CONFIG_TRUSTSTORE_LOCATION = "hbase.rpc.tls.truststore.location";
    public static final String TLS_CONFIG_TRUSTSTORE_TYPE = "hbase.rpc.tls.truststore.type";
    public static final String TLS_CONFIG_TRUSTSTORE_PASSWORD = "hbase.rpc.tls.truststore.password";
    public static final String TLS_CONFIG_CLR = "hbase.rpc.tls.clr";
    public static final String TLS_CONFIG_OCSP = "hbase.rpc.tls.ocsp";
    public static final String TLS_CONFIG_REVERSE_DNS_LOOKUP_ENABLED = "hbase.rpc.tls.host-verification.reverse-dns.enabled";
    public static final String TLS_ENABLED_PROTOCOLS = "hbase.rpc.tls.enabledProtocols";
    public static final String TLS_CIPHER_SUITES = "hbase.rpc.tls.ciphersuites";
    public static final String TLS_CERT_RELOAD = "hbase.rpc.tls.certReload";
    public static final String TLS_USE_OPENSSL = "hbase.rpc.tls.useOpenSsl";
    public static final String DEFAULT_PROTOCOL = "TLSv1.2";
    public static final String HBASE_SERVER_NETTY_TLS_ENABLED = "hbase.server.netty.tls.enabled";
    public static final String HBASE_SERVER_NETTY_TLS_CLIENT_AUTH_MODE = "hbase.server.netty.tls.client.auth.mode";
    public static final String HBASE_SERVER_NETTY_TLS_VERIFY_CLIENT_HOSTNAME = "hbase.server.netty.tls.verify.client.hostname";
    public static final String HBASE_SERVER_NETTY_TLS_SUPPORTPLAINTEXT = "hbase.server.netty.tls.supportplaintext";
    public static final String HBASE_SERVER_NETTY_TLS_WRAP_SIZE = "hbase.server.netty.tls.wrapSize";
    public static final int DEFAULT_HBASE_SERVER_NETTY_TLS_WRAP_SIZE = 0x100000;
    public static final String HBASE_CLIENT_NETTY_TLS_ENABLED = "hbase.client.netty.tls.enabled";
    public static final String HBASE_CLIENT_NETTY_TLS_VERIFY_SERVER_HOSTNAME = "hbase.client.netty.tls.verify.server.hostname";
    public static final String HBASE_CLIENT_NETTY_TLS_HANDSHAKETIMEOUT = "hbase.client.netty.tls.handshaketimeout";
    public static final int DEFAULT_HANDSHAKE_DETECTION_TIMEOUT_MILLIS = 5000;
    private static final String[] DEFAULT_CIPHERS_JAVA8 = (String[])ObjectArrays.concat((Object[])X509Util.getCBCCiphers(), (Object[])X509Util.getGCMCiphers(), String.class);
    private static final String[] DEFAULT_CIPHERS_JAVA9 = (String[])ObjectArrays.concat((Object[])X509Util.getGCMCiphers(), (Object[])X509Util.getCBCCiphers(), String.class);
    private static final String[] DEFAULT_CIPHERS_JAVA11 = (String[])ObjectArrays.concat((Object[])ObjectArrays.concat((Object[])X509Util.getTls13Ciphers(), (Object[])X509Util.getGCMCiphers(), String.class), (Object[])X509Util.getCBCCiphers(), String.class);
    private static final String[] DEFAULT_CIPHERS_OPENSSL = X509Util.getOpenSslFilteredDefaultCiphers();

    private static String[] getTls13Ciphers() {
        return new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"};
    }

    private static String[] getGCMCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    }

    private static String[] getCBCCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"};
    }

    private static String[] getOpenSslFilteredDefaultCiphers() {
        if (!OpenSsl.isAvailable()) {
            return new String[0];
        }
        Set openSslSuites = OpenSsl.availableJavaCipherSuites();
        ArrayList defaultSuites = new ArrayList();
        Arrays.stream(X509Util.getTls13Ciphers()).filter(openSslSuites::contains).forEach(defaultSuites::add);
        Arrays.stream(X509Util.getGCMCiphers()).filter(openSslSuites::contains).forEach(defaultSuites::add);
        Arrays.stream(X509Util.getCBCCiphers()).filter(openSslSuites::contains).forEach(defaultSuites::add);
        return defaultSuites.toArray(new String[0]);
    }

    private X509Util() {
    }

    static String[] getDefaultCipherSuites(boolean useOpenSsl) {
        if (useOpenSsl) {
            return DEFAULT_CIPHERS_OPENSSL;
        }
        return X509Util.getDefaultCipherSuitesForJavaVersion(System.getProperty("java.specification.version"));
    }

    static String[] getDefaultCipherSuitesForJavaVersion(String javaVersion) {
        Objects.requireNonNull(javaVersion);
        if (javaVersion.matches("\\d+")) {
            int javaVersionInt = Integer.parseInt(javaVersion);
            if (javaVersionInt >= 11) {
                LOG.debug("Using Java11+ optimized cipher suites for Java version {}, including TLSv1.3 support", (Object)javaVersion);
                return DEFAULT_CIPHERS_JAVA11;
            }
            LOG.debug("Using Java9+ optimized cipher suites for Java version {}", (Object)javaVersion);
            return DEFAULT_CIPHERS_JAVA9;
        }
        if (javaVersion.startsWith("1.")) {
            LOG.debug("Using Java8 optimized cipher suites for Java version {}", (Object)javaVersion);
            return DEFAULT_CIPHERS_JAVA8;
        }
        LOG.debug("Could not parse java version {}, using Java8 optimized cipher suites", (Object)javaVersion);
        return DEFAULT_CIPHERS_JAVA8;
    }

    public static SslContext createSslContextForClient(Configuration config) throws X509Exception, IOException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
        boolean useOpenSsl = X509Util.configureOpenSslIfAvailable(sslContextBuilder, config);
        String keyStoreLocation = config.get(TLS_CONFIG_KEYSTORE_LOCATION, "");
        char[] keyStorePassword = config.getPassword(TLS_CONFIG_KEYSTORE_PASSWORD);
        String keyStoreType = config.get(TLS_CONFIG_KEYSTORE_TYPE, "");
        if (keyStoreLocation.isEmpty()) {
            LOG.warn("hbase.rpc.tls.keystore.location not specified");
        } else {
            sslContextBuilder.keyManager((KeyManager)X509Util.createKeyManager(keyStoreLocation, keyStorePassword, keyStoreType));
        }
        String trustStoreLocation = config.get(TLS_CONFIG_TRUSTSTORE_LOCATION, "");
        char[] trustStorePassword = config.getPassword(TLS_CONFIG_TRUSTSTORE_PASSWORD);
        String trustStoreType = config.get(TLS_CONFIG_TRUSTSTORE_TYPE, "");
        boolean sslCrlEnabled = config.getBoolean(TLS_CONFIG_CLR, false);
        boolean sslOcspEnabled = config.getBoolean(TLS_CONFIG_OCSP, false);
        boolean verifyServerHostname = config.getBoolean(HBASE_CLIENT_NETTY_TLS_VERIFY_SERVER_HOSTNAME, true);
        boolean allowReverseDnsLookup = config.getBoolean(TLS_CONFIG_REVERSE_DNS_LOOKUP_ENABLED, true);
        if (trustStoreLocation.isEmpty()) {
            LOG.warn("hbase.rpc.tls.truststore.location not specified");
        } else {
            sslContextBuilder.trustManager((TrustManager)X509Util.createTrustManager(trustStoreLocation, trustStorePassword, trustStoreType, sslCrlEnabled, sslOcspEnabled, verifyServerHostname, allowReverseDnsLookup));
        }
        sslContextBuilder.enableOcsp(sslOcspEnabled);
        sslContextBuilder.protocols(X509Util.getEnabledProtocols(config));
        sslContextBuilder.ciphers(Arrays.asList(X509Util.getCipherSuites(config, useOpenSsl)));
        return sslContextBuilder.build();
    }

    private static boolean configureOpenSslIfAvailable(SslContextBuilder sslContextBuilder, Configuration conf) {
        if (OpenSsl.isAvailable() && conf.getBoolean(TLS_USE_OPENSSL, true)) {
            LOG.debug("Using netty-tcnative to accelerate SSL handling");
            sslContextBuilder.sslProvider(SslProvider.OPENSSL);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using default JDK SSL provider because netty-tcnative is not {}", (Object)(OpenSsl.isAvailable() ? "enabled" : "available"));
        }
        sslContextBuilder.sslProvider(SslProvider.JDK);
        return false;
    }

    public static SslContext createSslContextForServer(Configuration config) throws X509Exception, IOException {
        String keyStoreLocation = config.get(TLS_CONFIG_KEYSTORE_LOCATION, "");
        char[] keyStorePassword = config.getPassword(TLS_CONFIG_KEYSTORE_PASSWORD);
        String keyStoreType = config.get(TLS_CONFIG_KEYSTORE_TYPE, "");
        if (keyStoreLocation.isEmpty()) {
            throw new SSLContextException("Keystore is required for SSL server: hbase.rpc.tls.keystore.location");
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManager)X509Util.createKeyManager(keyStoreLocation, keyStorePassword, keyStoreType));
        boolean useOpenSsl = X509Util.configureOpenSslIfAvailable(sslContextBuilder, config);
        String trustStoreLocation = config.get(TLS_CONFIG_TRUSTSTORE_LOCATION, "");
        char[] trustStorePassword = config.getPassword(TLS_CONFIG_TRUSTSTORE_PASSWORD);
        String trustStoreType = config.get(TLS_CONFIG_TRUSTSTORE_TYPE, "");
        boolean sslCrlEnabled = config.getBoolean(TLS_CONFIG_CLR, false);
        boolean sslOcspEnabled = config.getBoolean(TLS_CONFIG_OCSP, false);
        ClientAuth clientAuth = ClientAuth.fromPropertyValue(config.get(HBASE_SERVER_NETTY_TLS_CLIENT_AUTH_MODE));
        boolean verifyClientHostname = config.getBoolean(HBASE_SERVER_NETTY_TLS_VERIFY_CLIENT_HOSTNAME, true);
        boolean allowReverseDnsLookup = config.getBoolean(TLS_CONFIG_REVERSE_DNS_LOOKUP_ENABLED, true);
        if (trustStoreLocation.isEmpty()) {
            LOG.warn("hbase.rpc.tls.truststore.location not specified");
        } else {
            sslContextBuilder.trustManager((TrustManager)X509Util.createTrustManager(trustStoreLocation, trustStorePassword, trustStoreType, sslCrlEnabled, sslOcspEnabled, verifyClientHostname, allowReverseDnsLookup));
        }
        sslContextBuilder.enableOcsp(sslOcspEnabled);
        sslContextBuilder.protocols(X509Util.getEnabledProtocols(config));
        sslContextBuilder.ciphers(Arrays.asList(X509Util.getCipherSuites(config, useOpenSsl)));
        sslContextBuilder.clientAuth(clientAuth.toNettyClientAuth());
        return sslContextBuilder.build();
    }

    static X509KeyManager createKeyManager(String keyStoreLocation, char[] keyStorePassword, String keyStoreType) throws KeyManagerException {
        if (keyStorePassword == null) {
            keyStorePassword = EMPTY_CHAR_ARRAY;
        }
        try {
            KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(keyStoreType, keyStoreLocation);
            KeyStore ks = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(storeFileType).setKeyStorePath(keyStoreLocation).setKeyStorePassword(keyStorePassword).build().loadKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
            kmf.init(ks, keyStorePassword);
            for (KeyManager km : kmf.getKeyManagers()) {
                if (!(km instanceof X509KeyManager)) continue;
                return (X509KeyManager)km;
            }
            throw new KeyManagerException("Couldn't find X509KeyManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new KeyManagerException(e);
        }
    }

    static X509TrustManager createTrustManager(String trustStoreLocation, char[] trustStorePassword, String trustStoreType, boolean crlEnabled, boolean ocspEnabled, boolean verifyHostName, boolean allowReverseDnsLookup) throws TrustManagerException {
        if (trustStorePassword == null) {
            trustStorePassword = EMPTY_CHAR_ARRAY;
        }
        try {
            KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(trustStoreType, trustStoreLocation);
            KeyStore ts = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(storeFileType).setTrustStorePath(trustStoreLocation).setTrustStorePassword(trustStorePassword).build().loadTrustStore();
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(ts, (CertSelector)new X509CertSelector());
            if (crlEnabled || ocspEnabled) {
                pbParams.setRevocationEnabled(true);
                System.setProperty("com.sun.net.ssl.checkRevocation", "true");
                if (crlEnabled) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                }
                if (ocspEnabled) {
                    Security.setProperty("ocsp.enable", "true");
                }
            } else {
                pbParams.setRevocationEnabled(false);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(new CertPathTrustManagerParameters(pbParams));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                return new HBaseTrustManager((X509ExtendedTrustManager)tm, verifyHostName, allowReverseDnsLookup);
            }
            throw new TrustManagerException("Couldn't find X509TrustManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new TrustManagerException(e);
        }
    }

    private static String[] getEnabledProtocols(Configuration config) {
        String enabledProtocolsInput = config.get(TLS_ENABLED_PROTOCOLS);
        if (enabledProtocolsInput == null) {
            return new String[]{config.get(TLS_CONFIG_PROTOCOL, DEFAULT_PROTOCOL)};
        }
        return enabledProtocolsInput.split(",");
    }

    private static String[] getCipherSuites(Configuration config, boolean useOpenSsl) {
        String cipherSuitesInput = config.get(TLS_CIPHER_SUITES);
        if (cipherSuitesInput == null) {
            return X509Util.getDefaultCipherSuites(useOpenSsl);
        }
        return cipherSuitesInput.split(",");
    }

    public static void enableCertFileReloading(Configuration config, AtomicReference<FileChangeWatcher> keystoreWatcher, AtomicReference<FileChangeWatcher> trustStoreWatcher, Runnable resetContext) throws IOException {
        String keyStoreLocation = config.get(TLS_CONFIG_KEYSTORE_LOCATION, "");
        keystoreWatcher.set(X509Util.newFileChangeWatcher(keyStoreLocation, resetContext));
        String trustStoreLocation = config.get(TLS_CONFIG_TRUSTSTORE_LOCATION, "");
        if (!keyStoreLocation.equals(trustStoreLocation)) {
            trustStoreWatcher.set(X509Util.newFileChangeWatcher(trustStoreLocation, resetContext));
        }
    }

    private static FileChangeWatcher newFileChangeWatcher(String fileLocation, Runnable resetContext) throws IOException {
        if (fileLocation == null || fileLocation.isEmpty() || resetContext == null) {
            return null;
        }
        Path filePath = Paths.get(fileLocation, new String[0]).toAbsolutePath();
        Path parentPath = filePath.getParent();
        if (parentPath == null) {
            throw new IOException("Key/trust store path does not have a parent: " + filePath);
        }
        FileChangeWatcher fileChangeWatcher = new FileChangeWatcher(parentPath, Objects.toString(filePath.getFileName()), watchEvent -> X509Util.handleWatchEvent(filePath, watchEvent, resetContext));
        fileChangeWatcher.start();
        return fileChangeWatcher;
    }

    private static void handleWatchEvent(Path filePath, WatchEvent<?> event, Runnable resetContext) {
        Path eventFilePath;
        boolean shouldResetContext = false;
        Path dirPath = filePath.getParent();
        if (event.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
            shouldResetContext = true;
        } else if ((event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) || event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE)) && filePath.equals(eventFilePath = dirPath.resolve((Path)event.context()))) {
            shouldResetContext = true;
        }
        if (shouldResetContext) {
            LOG.info("Attempting to reset default SSL context after receiving watch event: {} with context: {}", event.kind(), event.context());
            resetContext.run();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring watch event and keeping previous default SSL context. Event kind: {} with context: {}", event.kind(), event.context());
        }
    }

    public static enum ClientAuth {
        NONE(org.apache.hbase.thirdparty.io.netty.handler.ssl.ClientAuth.NONE),
        WANT(org.apache.hbase.thirdparty.io.netty.handler.ssl.ClientAuth.OPTIONAL),
        NEED(org.apache.hbase.thirdparty.io.netty.handler.ssl.ClientAuth.REQUIRE);

        private final org.apache.hbase.thirdparty.io.netty.handler.ssl.ClientAuth nettyAuth;

        private ClientAuth(org.apache.hbase.thirdparty.io.netty.handler.ssl.ClientAuth nettyAuth) {
            this.nettyAuth = nettyAuth;
        }

        public static ClientAuth fromPropertyValue(String prop) {
            if (prop == null || prop.length() == 0) {
                return NEED;
            }
            return ClientAuth.valueOf(prop.toUpperCase());
        }

        public org.apache.hbase.thirdparty.io.netty.handler.ssl.ClientAuth toNettyClientAuth() {
            return this.nettyAuth;
        }
    }
}

