/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessageMutator;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationPropertiesSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DeliveryAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Footer;
import org.apache.qpid.server.protocol.v1_0.type.messaging.FooterSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.HeaderSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.PropertiesSection;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class Message_1_0_Mutator
implements ServerMessageMutator<Message_1_0> {
    private final Message_1_0 _message;
    private final MessageStore _messageStore;
    private Header _header;
    private Map<Symbol, Object> _deliveryAnnotations;
    private Map<Symbol, Object> _messageAnnotations;
    private Properties _properties;
    private Map<String, Object> _applicationProperties;
    private Map<Symbol, Object> _footer;

    Message_1_0_Mutator(Message_1_0 message, MessageStore messageStore) {
        FooterSection footerSection;
        ApplicationPropertiesSection applicationPropertiesSection;
        PropertiesSection propertiesSection;
        MessageAnnotationsSection messageAnnotationsSection;
        DeliveryAnnotationsSection deliveryAnnotationsSection;
        this._message = message;
        this._messageStore = messageStore;
        HeaderSection headerSection = message.getHeaderSection();
        if (headerSection != null) {
            Header header = (Header)headerSection.getValue();
            if (header != null) {
                this._header = new Header();
                this._header.setDeliveryCount(header.getDeliveryCount());
                this._header.setDurable(header.getDurable());
                this._header.setFirstAcquirer(header.getFirstAcquirer());
                this._header.setPriority(header.getPriority());
                this._header.setTtl(header.getTtl());
            }
            headerSection.dispose();
        }
        if ((deliveryAnnotationsSection = message.getDeliveryAnnotationsSection()) != null) {
            Map deliveryAnnotations = (Map)deliveryAnnotationsSection.getValue();
            if (deliveryAnnotations != null) {
                this._deliveryAnnotations = new HashMap<Symbol, Object>(deliveryAnnotations);
            }
            deliveryAnnotationsSection.dispose();
        }
        if ((messageAnnotationsSection = message.getMessageAnnotationsSection()) != null) {
            Map messageAnnotations = (Map)messageAnnotationsSection.getValue();
            if (messageAnnotations != null) {
                this._messageAnnotations = new HashMap<Symbol, Object>(messageAnnotations);
            }
            messageAnnotationsSection.dispose();
        }
        if ((propertiesSection = message.getPropertiesSection()) != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            if (properties != null) {
                this._properties = new Properties();
                this._properties.setCorrelationId(properties.getCorrelationId());
                this._properties.setAbsoluteExpiryTime(properties.getAbsoluteExpiryTime());
                this._properties.setContentEncoding(properties.getContentEncoding());
                this._properties.setContentType(properties.getContentType());
                this._properties.setCreationTime(properties.getCreationTime());
                this._properties.setGroupId(properties.getGroupId());
                this._properties.setGroupSequence(properties.getGroupSequence());
                this._properties.setMessageId(properties.getMessageId());
                this._properties.setReplyTo(properties.getReplyTo());
                this._properties.setReplyToGroupId(properties.getReplyToGroupId());
                this._properties.setSubject(properties.getSubject());
                this._properties.setTo(properties.getTo());
                this._properties.setUserId(properties.getUserId());
            }
            propertiesSection.dispose();
        }
        if ((applicationPropertiesSection = message.getApplicationPropertiesSection()) != null) {
            Map applicationProperties = (Map)applicationPropertiesSection.getValue();
            if (applicationProperties != null) {
                this._applicationProperties = new HashMap<String, Object>(applicationProperties);
            }
            applicationPropertiesSection.dispose();
        }
        if ((footerSection = message.getFooterSection()) != null) {
            Map footer = (Map)footerSection.getValue();
            if (footer != null) {
                this._footer = new HashMap<Symbol, Object>(footer);
            }
            footerSection.dispose();
        }
    }

    public void setPriority(byte priority) {
        if (this._header == null) {
            this._header = new Header();
        }
        this._header.setPriority(UnsignedByte.valueOf(priority));
    }

    public byte getPriority() {
        if (this._header == null || this._header.getPriority() == null) {
            return 4;
        }
        return this._header.getPriority().byteValue();
    }

    public Message_1_0 create() {
        long contentSize = this._message.getSize();
        HeaderSection headerSection = null;
        if (this._header != null) {
            headerSection = this._header.createEncodingRetainingSection();
        }
        DeliveryAnnotationsSection deliveryAnnotationsSection = null;
        if (this._deliveryAnnotations != null) {
            deliveryAnnotationsSection = new DeliveryAnnotations(this._deliveryAnnotations).createEncodingRetainingSection();
        }
        MessageAnnotationsSection messageAnnotationsSection = null;
        if (this._messageAnnotations != null) {
            messageAnnotationsSection = new MessageAnnotations(this._messageAnnotations).createEncodingRetainingSection();
        }
        PropertiesSection propertiesSection = null;
        if (this._properties != null) {
            propertiesSection = this._properties.createEncodingRetainingSection();
        }
        ApplicationPropertiesSection applicationPropertiesSection = null;
        if (this._applicationProperties != null) {
            applicationPropertiesSection = new ApplicationProperties(this._applicationProperties).createEncodingRetainingSection();
        }
        FooterSection footerSection = null;
        if (this._footer != null) {
            footerSection = new Footer(this._footer).createEncodingRetainingSection();
        }
        QpidByteBuffer content = this._message.getContent();
        MessageMetaData_1_0 mmd = new MessageMetaData_1_0(headerSection, deliveryAnnotationsSection, messageAnnotationsSection, propertiesSection, applicationPropertiesSection, footerSection, this._message.getArrivalTime(), contentSize);
        MessageHandle handle = this._messageStore.addMessage((StorableMessageMetaData)mmd);
        if (content != null) {
            handle.addContent(content);
        }
        return new Message_1_0((StoredMessage<MessageMetaData_1_0>)handle.allContentAdded(), this._message.getConnectionReference());
    }
}

