/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.util.Objects;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.DivideExpression;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.MinusExpression;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.ModExpression;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.MultiplyExpression;
import org.apache.qpid.server.query.engine.parsing.expression.arithmetic.PlusExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;

public final class ArithmeticExpressionFactory {
    private ArithmeticExpressionFactory() {
    }

    public static <T, R> ExpressionNode<T, R> divide(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        DivideExpression<T, R> result = new DivideExpression<T, R>(alias, left, right);
        return result.isInstantlyEvaluable() ? ConstantExpression.of(result.getAlias(), result.apply(null)) : result;
    }

    public static <T, R> ExpressionNode<T, R> minus(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        MinusExpression<T, R> result = new MinusExpression<T, R>(alias, left, right);
        return result.isInstantlyEvaluable() ? ConstantExpression.of(result.getAlias(), result.apply(null)) : result;
    }

    public static <T, R> ExpressionNode<T, R> mod(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        ModExpression<T, R> result = new ModExpression<T, R>(alias, left, right);
        return result.isInstantlyEvaluable() ? ConstantExpression.of(result.getAlias(), result.apply(null)) : result;
    }

    public static <T, R> ExpressionNode<T, R> multiply(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        MultiplyExpression<T, R> result = new MultiplyExpression<T, R>(alias, left, right);
        return result.isInstantlyEvaluable() ? ConstantExpression.of(result.getAlias(), result.apply(null)) : result;
    }

    public static <T, R> ExpressionNode<T, R> plus(String alias, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        Objects.requireNonNull(left, "Child expression should be not null");
        Objects.requireNonNull(right, "Child expression should be not null");
        PlusExpression<T, R> result = new PlusExpression<T, R>(alias, left, right);
        return result.isInstantlyEvaluable() ? ConstantExpression.of(result.getAlias(), result.apply(null)) : result;
    }
}

