/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.datetime;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class DateAddExpression<T, R>
extends AbstractFunctionExpression<T, Instant> {
    private final FunctionParameterTypePredicate<Number> _numberValidator = FunctionParameterTypePredicate.builder().allowNumbers().build();
    private final FunctionParameterTypePredicate<R> _dateTimeValidator = FunctionParameterTypePredicate.builder().allowDateTimeTypes().allowStrings().build();

    public DateAddExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(3, args, this);
    }

    @Override
    public Instant apply(T value) {
        QuerySettings querySettings = (QuerySettings)this.ctx().get("query.settings");
        ChronoUnit datePart = (ChronoUnit)this.evaluateChild(0, null);
        Number amountToAdd = this.evaluateChild(1, null, this._numberValidator);
        R dateTime = this.evaluateChild(2, value, this._dateTimeValidator);
        Instant instant = DateTimeConverter.toInstantMapper().apply(dateTime);
        return instant.atZone(querySettings.getZoneId()).plus(amountToAdd.longValue(), datePart).toInstant();
    }
}

