/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.bytebuffer.ByteBufferRef;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;

class PooledByteBufferRef
implements ByteBufferRef {
    private static final AtomicIntegerFieldUpdater<PooledByteBufferRef> REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PooledByteBufferRef.class, "_refCount");
    private static final AtomicIntegerFieldUpdater<PooledByteBufferRef> CLAIMED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PooledByteBufferRef.class, "_claimed");
    private static final AtomicInteger ACTIVE_BUFFERS = new AtomicInteger();
    private static final AtomicLong DISPOSAL_COUNTER = new AtomicLong();
    private final ByteBuffer _buffer;
    private volatile int _refCount;
    private volatile int _claimed;

    PooledByteBufferRef(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this._buffer = buffer;
        ACTIVE_BUFFERS.incrementAndGet();
    }

    @Override
    public void incrementRef(int capacity) {
        if (REF_COUNT_UPDATER.get(this) >= 0) {
            CLAIMED_UPDATER.addAndGet(this, capacity);
            REF_COUNT_UPDATER.incrementAndGet(this);
        }
    }

    @Override
    public void decrementRef(int capacity) {
        CLAIMED_UPDATER.addAndGet(this, -capacity);
        DISPOSAL_COUNTER.incrementAndGet();
        if (REF_COUNT_UPDATER.get(this) > 0 && REF_COUNT_UPDATER.decrementAndGet(this) == 0) {
            QpidByteBuffer.returnToPool(this._buffer);
            ACTIVE_BUFFERS.decrementAndGet();
        }
    }

    @Override
    public ByteBuffer getBuffer() {
        return this._buffer.duplicate();
    }

    @Override
    public boolean isSparse(double minimumSparsityFraction) {
        return minimumSparsityFraction > (double)CLAIMED_UPDATER.get(this) / (double)this._buffer.capacity();
    }

    static int getActiveBufferCount() {
        return ACTIVE_BUFFERS.get();
    }

    static long getDisposalCounter() {
        return DISPOSAL_COUNTER.get();
    }
}

