/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util.verify;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.util.DbVerifyLog;
import com.sleepycat.je.util.LogVerificationException;
import com.sleepycat.je.utilint.CronScheduleParser;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.Timer;
import java.util.TimerTask;

public class DataVerifier {
    private final EnvironmentImpl envImpl;
    private final Timer timer;
    private VerifyTask verifyTask;
    private final DbVerifyLog dbLogVerifier;
    private long verifyDelay;
    private long verifyInterval;
    private String cronSchedule;
    private boolean shutdownRequest = false;

    public DataVerifier(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.timer = new Timer(envImpl.makeDaemonThreadName("DataCorruptionVerifier"), true);
        this.dbLogVerifier = new DbVerifyLog(envImpl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configVerifyTask(DbConfigManager configMgr) {
        if (!this.updateConfig(configMgr)) {
            return;
        }
        DataVerifier dataVerifier = this;
        synchronized (dataVerifier) {
            if (!this.shutdownRequest) {
                this.cancel();
                if (this.cronSchedule != null) {
                    this.verifyTask = new VerifyTask(this.envImpl, configMgr.getBoolean(EnvironmentParams.VERIFY_LOG), configMgr.getBoolean(EnvironmentParams.VERIFY_BTREE), configMgr.getBoolean(EnvironmentParams.VERIFY_SECONDARIES), configMgr.getBoolean(EnvironmentParams.VERIFY_DATA_RECORDS), configMgr.getBoolean(EnvironmentParams.VERIFY_OBSOLETE_RECORDS));
                    this.timer.schedule((TimerTask)this.verifyTask, this.verifyDelay, this.verifyInterval);
                }
            }
        }
    }

    private void cancel() {
        if (this.verifyTask != null) {
            this.verifyTask.cancel();
            this.verifyTask = null;
        }
    }

    public void requestShutdown() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DataVerifier dataVerifier = this;
        synchronized (dataVerifier) {
            this.shutdownRequest = true;
            this.cancel();
            this.timer.cancel();
            this.dbLogVerifier.setStopVerifyFlag();
        }
    }

    public long getVerifyDelay() {
        return this.verifyDelay;
    }

    public long getVerifyInterval() {
        return this.verifyInterval;
    }

    public VerifyTask getVerifyTask() {
        return this.verifyTask;
    }

    public String getCronSchedule() {
        return this.cronSchedule;
    }

    private boolean updateConfig(DbConfigManager configMgr) {
        String newCronSchedule = configMgr.get(EnvironmentParams.VERIFY_SCHEDULE);
        if (!configMgr.getBoolean(EnvironmentParams.ENV_RUN_VERIFIER)) {
            newCronSchedule = null;
            if (this.cronSchedule == null) {
                return false;
            }
            this.cronSchedule = null;
            this.verifyDelay = 0L;
            this.verifyInterval = 0L;
            return true;
        }
        if (CronScheduleParser.checkSame(this.cronSchedule, newCronSchedule)) {
            return false;
        }
        CronScheduleParser csp = new CronScheduleParser(newCronSchedule);
        this.verifyDelay = csp.getDelayTime();
        this.verifyInterval = csp.getInterval();
        this.cronSchedule = newCronSchedule;
        return true;
    }

    class VerifyTask
    extends TimerTask {
        private final EnvironmentImpl envImpl;
        private final boolean verifyLog;
        private final boolean verifyBtree;
        private final boolean verifySecondaries;
        private final boolean verifyDataRecords;
        private final boolean verifyObsoleteRecords;

        VerifyTask(EnvironmentImpl envImpl, boolean verifyLog, boolean verifyBtree, boolean verifySecondaries, boolean verifyDataRecords, boolean verifyObsoleteRecords) {
            this.envImpl = envImpl;
            this.verifyLog = verifyLog;
            this.verifyBtree = verifyBtree;
            this.verifySecondaries = verifySecondaries;
            this.verifyDataRecords = verifyDataRecords;
            this.verifyObsoleteRecords = verifyObsoleteRecords;
        }

        @Override
        public void run() {
            boolean success = false;
            try {
                if (this.verifyLog) {
                    DataVerifier.this.dbLogVerifier.verifyAll();
                }
                success = true;
            }
            catch (LogVerificationException lve) {
                new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Corruption detected by log verifier", lve);
            }
            catch (EnvironmentFailureException lve) {
            }
            catch (Throwable e) {
                if (this.envImpl.isValid()) {
                    StoppableThread.handleUncaughtException(this.envImpl.getLogger(), this.envImpl, Thread.currentThread(), e);
                }
            }
            finally {
                if (!success) {
                    DataVerifier.this.shutdown();
                }
            }
        }
    }
}

