/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.Timer;
import java.util.TimerTask;

public class LogFlusher {
    private final EnvironmentImpl envImpl;
    private final Timer timer;
    private int flushSyncInterval;
    private int flushNoSyncInterval;
    private FlushTask flushSyncTask;
    private FlushTask flushNoSyncTask;
    private boolean shutdownRequest = false;

    public LogFlusher(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.timer = new Timer(envImpl.makeDaemonThreadName("LogFlusher"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configFlushTask(DbConfigManager configMgr) {
        if (!this.updateConfig(configMgr)) {
            return;
        }
        LogFlusher logFlusher = this;
        synchronized (logFlusher) {
            if (!this.shutdownRequest) {
                this.cancel();
                if (this.flushSyncInterval > 0) {
                    this.flushSyncTask = new FlushTask(this.envImpl, true);
                    this.timer.schedule((TimerTask)this.flushSyncTask, this.flushSyncInterval, (long)this.flushSyncInterval);
                }
                if (this.flushNoSyncInterval > 0) {
                    this.flushNoSyncTask = new FlushTask(this.envImpl, false);
                    this.timer.schedule((TimerTask)this.flushNoSyncTask, this.flushNoSyncInterval, (long)this.flushNoSyncInterval);
                }
            }
        }
    }

    private void cancel() {
        if (this.flushSyncTask != null) {
            this.flushSyncTask.cancel();
            this.flushSyncTask = null;
        }
        if (this.flushNoSyncTask != null) {
            this.flushNoSyncTask.cancel();
            this.flushNoSyncTask = null;
        }
    }

    public void requestShutdown() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LogFlusher logFlusher = this;
        synchronized (logFlusher) {
            this.shutdownRequest = true;
            this.cancel();
            this.timer.cancel();
        }
    }

    private boolean updateConfig(DbConfigManager configMgr) {
        int newNoSyncInterval;
        int newSyncInternal;
        if (configMgr.isSpecified(EnvironmentParams.OLD_REP_RUN_LOG_FLUSH_TASK) && !configMgr.getBoolean(EnvironmentParams.OLD_REP_RUN_LOG_FLUSH_TASK)) {
            if (configMgr.isSpecified(EnvironmentParams.LOG_FLUSH_SYNC_INTERVAL) || configMgr.isSpecified(EnvironmentParams.LOG_FLUSH_NO_SYNC_INTERVAL)) {
                throw new IllegalArgumentException("When " + EnvironmentParams.OLD_REP_RUN_LOG_FLUSH_TASK.getName() + " is set to false, " + EnvironmentParams.LOG_FLUSH_SYNC_INTERVAL + " and " + EnvironmentParams.LOG_FLUSH_NO_SYNC_INTERVAL + " must not be specified.");
            }
            newSyncInternal = 0;
            newNoSyncInterval = 0;
        } else {
            if (configMgr.isSpecified(EnvironmentParams.OLD_REP_LOG_FLUSH_TASK_INTERVAL)) {
                if (configMgr.isSpecified(EnvironmentParams.LOG_FLUSH_SYNC_INTERVAL)) {
                    throw new IllegalArgumentException("Both " + EnvironmentParams.OLD_REP_LOG_FLUSH_TASK_INTERVAL.getName() + " and " + EnvironmentParams.LOG_FLUSH_SYNC_INTERVAL + " must not be specified.");
                }
                newSyncInternal = configMgr.getDuration(EnvironmentParams.OLD_REP_LOG_FLUSH_TASK_INTERVAL);
            } else {
                newSyncInternal = configMgr.getDuration(EnvironmentParams.LOG_FLUSH_SYNC_INTERVAL);
            }
            newNoSyncInterval = configMgr.getDuration(EnvironmentParams.LOG_FLUSH_NO_SYNC_INTERVAL);
        }
        if (newSyncInternal == this.flushSyncInterval && newNoSyncInterval == this.flushNoSyncInterval) {
            return false;
        }
        this.flushSyncInterval = newSyncInternal;
        this.flushNoSyncInterval = newNoSyncInterval;
        return true;
    }

    int getFlushSyncInterval() {
        return this.flushSyncInterval;
    }

    int getFlushNoSyncInterval() {
        return this.flushNoSyncInterval;
    }

    FlushTask getFlushSyncTask() {
        return this.flushSyncTask;
    }

    FlushTask getFlushNoSyncTask() {
        return this.flushNoSyncTask;
    }

    static class FlushTask
    extends TimerTask {
        private final EnvironmentImpl envImpl;
        private final boolean fsync;
        private long lastNCommits;
        private volatile int flushCount;

        FlushTask(EnvironmentImpl envImpl, boolean fsync) {
            this.envImpl = envImpl;
            this.fsync = fsync;
            this.lastNCommits = envImpl.getTxnManager().getNTotalCommits();
        }

        int getFlushCount() {
            return this.flushCount;
        }

        @Override
        public void run() {
            block5: {
                try {
                    long newNCommits = this.envImpl.getTxnManager().getNTotalCommits();
                    if (newNCommits <= this.lastNCommits) {
                        return;
                    }
                    if (this.fsync) {
                        this.envImpl.getLogManager().flushSync();
                    } else {
                        this.envImpl.getLogManager().flushNoSync();
                    }
                    this.lastNCommits = newNCommits;
                    ++this.flushCount;
                }
                catch (Throwable e) {
                    if (!this.envImpl.isValid()) break block5;
                    StoppableThread.handleUncaughtException(this.envImpl.getLogger(), this.envImpl, Thread.currentThread(), e);
                }
            }
        }
    }
}

