/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TSFBuilder;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.DataOutputAsStream;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.sym.SimpleNameMatcher;
import tools.jackson.core.util.BufferRecycler;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JsonRecyclerPools;
import tools.jackson.core.util.Named;
import tools.jackson.core.util.RecyclerPool;
import tools.jackson.core.util.Snapshottable;

public abstract class TokenStreamFactory
implements Versioned,
Serializable,
Snapshottable<TokenStreamFactory> {
    private static final long serialVersionUID = 3L;
    public static final ObjectWriteContext EMPTY_WRITE_CONTEXT = new ObjectWriteContext.Base();
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = Feature.collectDefaults();
    protected static final int DEFAULT_STREAM_READ_FEATURE_FLAGS = StreamReadFeature.collectDefaults();
    protected static final int DEFAULT_STREAM_WRITE_FEATURE_FLAGS = StreamWriteFeature.collectDefaults();
    protected final int _factoryFeatures;
    protected final int _streamReadFeatures;
    protected final int _streamWriteFeatures;
    protected final int _formatReadFeatures;
    protected final int _formatWriteFeatures;
    protected final RecyclerPool<BufferRecycler> _recyclerPool;
    protected final StreamReadConstraints _streamReadConstraints;
    protected final StreamWriteConstraints _streamWriteConstraints;
    protected final ErrorReportConfiguration _errorReportConfiguration;

    protected TokenStreamFactory(StreamReadConstraints src, StreamWriteConstraints swc, ErrorReportConfiguration erc, int formatReadFeatures, int formatWriteFeatures) {
        this._streamReadConstraints = Objects.requireNonNull(src);
        this._streamWriteConstraints = Objects.requireNonNull(swc);
        this._errorReportConfiguration = Objects.requireNonNull(erc);
        this._recyclerPool = JsonRecyclerPools.defaultPool();
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._streamReadFeatures = DEFAULT_STREAM_READ_FEATURE_FLAGS;
        this._streamWriteFeatures = DEFAULT_STREAM_WRITE_FEATURE_FLAGS;
        this._formatReadFeatures = formatReadFeatures;
        this._formatWriteFeatures = formatWriteFeatures;
    }

    protected TokenStreamFactory(TSFBuilder<?, ?> baseBuilder) {
        this._streamReadConstraints = Objects.requireNonNull(baseBuilder._streamReadConstraints);
        this._streamWriteConstraints = Objects.requireNonNull(baseBuilder._streamWriteConstraints);
        this._errorReportConfiguration = Objects.requireNonNull(baseBuilder._errorReportConfiguration);
        RecyclerPool<BufferRecycler> rp = baseBuilder._recyclerPool;
        if (rp == null) {
            rp = JsonRecyclerPools.defaultPool();
        }
        this._recyclerPool = rp;
        this._factoryFeatures = baseBuilder.factoryFeaturesMask();
        this._streamReadFeatures = baseBuilder.streamReadFeaturesMask();
        this._streamWriteFeatures = baseBuilder.streamWriteFeaturesMask();
        this._formatReadFeatures = baseBuilder.formatReadFeaturesMask();
        this._formatWriteFeatures = baseBuilder.formatWriteFeaturesMask();
    }

    protected TokenStreamFactory(TokenStreamFactory src) {
        this._streamReadConstraints = src._streamReadConstraints;
        this._streamWriteConstraints = src._streamWriteConstraints;
        this._errorReportConfiguration = src._errorReportConfiguration;
        this._recyclerPool = src._recyclerPool;
        this._factoryFeatures = src._factoryFeatures;
        this._streamReadFeatures = src._streamReadFeatures;
        this._streamWriteFeatures = src._streamWriteFeatures;
        this._formatReadFeatures = src._formatReadFeatures;
        this._formatWriteFeatures = src._formatWriteFeatures;
    }

    public abstract TokenStreamFactory copy();

    @Override
    public abstract TokenStreamFactory snapshot();

    public abstract TSFBuilder<?, ?> rebuild();

    public boolean requiresPropertyOrdering() {
        return false;
    }

    public abstract boolean canHandleBinaryNatively();

    public abstract boolean canParseAsync();

    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return null;
    }

    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return null;
    }

    public abstract boolean canUseSchema(FormatSchema var1);

    public abstract String getFormatName();

    @Override
    public abstract Version version();

    public final boolean isEnabled(Feature f) {
        return (this._factoryFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(StreamReadFeature f) {
        return (this._streamReadFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(StreamWriteFeature f) {
        return (this._streamWriteFeatures & f.getMask()) != 0;
    }

    public final int getFactoryFeatures() {
        return this._factoryFeatures;
    }

    public final int getStreamReadFeatures() {
        return this._streamReadFeatures;
    }

    public final int getStreamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public int getFormatReadFeatures() {
        return this._formatReadFeatures;
    }

    public int getFormatWriteFeatures() {
        return this._formatWriteFeatures;
    }

    public StreamReadConstraints streamReadConstraints() {
        return this._streamReadConstraints;
    }

    public StreamWriteConstraints streamWriteConstraints() {
        return this._streamWriteConstraints;
    }

    public ErrorReportConfiguration errorReportConfiguration() {
        return this._errorReportConfiguration;
    }

    public PropertyNameMatcher constructNameMatcher(List<Named> matches, boolean alreadyInterned) {
        return SimpleNameMatcher.constructFrom(null, matches, alreadyInterned);
    }

    public PropertyNameMatcher constructCINameMatcher(List<Named> matches, boolean alreadyInterned, Locale locale) {
        return SimpleNameMatcher.constructCaseInsensitive(locale, matches, alreadyInterned);
    }

    public abstract JsonParser createParser(ObjectReadContext var1, File var2) throws JacksonException;

    public abstract JsonParser createParser(ObjectReadContext var1, Path var2) throws JacksonException;

    public abstract JsonParser createParser(ObjectReadContext var1, InputStream var2) throws JacksonException;

    public abstract JsonParser createParser(ObjectReadContext var1, Reader var2) throws JacksonException;

    public JsonParser createParser(ObjectReadContext readCtxt, byte[] data) throws JacksonException {
        return this.createParser(readCtxt, data, 0, data.length);
    }

    public abstract JsonParser createParser(ObjectReadContext var1, byte[] var2, int var3, int var4) throws JacksonException;

    public abstract JsonParser createParser(ObjectReadContext var1, String var2) throws JacksonException;

    public JsonParser createParser(ObjectReadContext readCtxt, char[] content) throws JacksonException {
        return this.createParser(readCtxt, content, 0, content.length);
    }

    public abstract JsonParser createParser(ObjectReadContext var1, char[] var2, int var3, int var4) throws JacksonException;

    @Deprecated
    public JsonParser createParser(File f) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), f);
    }

    @Deprecated
    public JsonParser createParser(InputStream in) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), in);
    }

    @Deprecated
    public JsonParser createParser(Reader r) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), r);
    }

    @Deprecated
    public JsonParser createParser(byte[] content) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), content, 0, content.length);
    }

    @Deprecated
    public JsonParser createParser(byte[] content, int offset, int len) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), content, offset, len);
    }

    @Deprecated
    public JsonParser createParser(String content) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), content);
    }

    @Deprecated
    public JsonParser createParser(char[] content) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), content, 0, content.length);
    }

    @Deprecated
    public JsonParser createParser(char[] content, int offset, int len) throws JacksonException {
        return this.createParser(ObjectReadContext.empty(), content, offset, len);
    }

    public abstract JsonParser createParser(ObjectReadContext var1, DataInput var2) throws JacksonException;

    public <P extends JsonParser> P createNonBlockingByteArrayParser(ObjectReadContext readCtxt) throws JacksonException {
        return (P)((JsonParser)this._unsupported("Non-blocking source not (yet?) supported for this format (" + this.getFormatName() + ")", new Object[0]));
    }

    public <P extends JsonParser> P createNonBlockingByteBufferParser(ObjectReadContext readCtxt) throws JacksonException {
        return (P)((JsonParser)this._unsupported("Non-blocking source not (yet?) supported for this format (" + this.getFormatName() + ")", new Object[0]));
    }

    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, OutputStream out) throws JacksonException {
        return this.createGenerator(writeCtxt, out, JsonEncoding.UTF8);
    }

    public abstract JsonGenerator createGenerator(ObjectWriteContext var1, OutputStream var2, JsonEncoding var3) throws JacksonException;

    public abstract JsonGenerator createGenerator(ObjectWriteContext var1, Writer var2) throws JacksonException;

    public abstract JsonGenerator createGenerator(ObjectWriteContext var1, File var2, JsonEncoding var3) throws JacksonException;

    public abstract JsonGenerator createGenerator(ObjectWriteContext var1, Path var2, JsonEncoding var3) throws JacksonException;

    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, DataOutput out) throws JacksonException {
        return this.createGenerator(writeCtxt, this._createDataOutputWrapper(out));
    }

    @Deprecated
    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws JacksonException {
        return this.createGenerator(ObjectWriteContext.empty(), out, enc);
    }

    @Deprecated
    public JsonGenerator createGenerator(OutputStream out) throws JacksonException {
        return this.createGenerator(ObjectWriteContext.empty(), out, JsonEncoding.UTF8);
    }

    @Deprecated
    public JsonGenerator createGenerator(Writer w) throws JacksonException {
        return this.createGenerator(ObjectWriteContext.empty(), w);
    }

    public BufferRecycler _getBufferRecycler() {
        return this._getRecyclerPool().acquireAndLinkPooled();
    }

    public RecyclerPool<BufferRecycler> _getRecyclerPool() {
        return this._recyclerPool;
    }

    protected IOContext _createContext(ContentReference contentRef, boolean resourceManaged) {
        return this._createContext(contentRef, resourceManaged, null);
    }

    protected IOContext _createContext(ContentReference contentRef, boolean resourceManaged, JsonEncoding enc) {
        boolean recyclerExternal;
        Object content;
        BufferRecycler br = null;
        Object object = content = contentRef == null ? null : contentRef.getRawContent();
        if (content instanceof BufferRecycler.Gettable) {
            br = ((BufferRecycler.Gettable)content).bufferRecycler();
        }
        boolean bl = recyclerExternal = br != null;
        if (!recyclerExternal) {
            br = this._getBufferRecycler();
        }
        IOContext ctxt = new IOContext(this._streamReadConstraints, this._streamWriteConstraints, this._errorReportConfiguration, br, contentRef, resourceManaged, enc);
        if (recyclerExternal) {
            ctxt.markBufferRecyclerReleased();
        }
        return ctxt;
    }

    protected abstract ContentReference _createContentReference(Object var1);

    protected abstract ContentReference _createContentReference(Object var1, int var2, int var3);

    protected OutputStream _createDataOutputWrapper(DataOutput out) {
        return new DataOutputAsStream(out);
    }

    @Deprecated
    protected InputStream _optimizedStreamFromURL(URL url) throws JacksonException {
        String path;
        String host;
        if ("file".equals(url.getProtocol()) && ((host = url.getHost()) == null || host.length() == 0) && (path = url.getPath()).indexOf(37) < 0) {
            try {
                return new FileInputStream(url.getPath());
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected InputStream _fileInputStream(File f) throws JacksonException {
        try {
            return new FileInputStream(f);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected InputStream _pathInputStream(Path p) throws JacksonException {
        try {
            return Files.newInputStream(p, new OpenOption[0]);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected OutputStream _fileOutputStream(File f) throws JacksonException {
        try {
            return new FileOutputStream(f);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected OutputStream _pathOutputStream(Path p) throws JacksonException {
        try {
            return Files.newOutputStream(p, new OpenOption[0]);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected void _checkRangeBoundsForByteArray(byte[] data, int offset, int len) throws JacksonException {
        int dataLen;
        int end;
        int anyNegs;
        if (data == null) {
            this._reportRangeError("Invalid `byte[]` argument: `null`");
        }
        if ((anyNegs = offset | len | (end = offset + len) | (dataLen = data.length) - end) < 0) {
            this._reportRangeError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `byte[]` of length %d", offset, len, dataLen));
        }
    }

    protected void _checkRangeBoundsForCharArray(char[] data, int offset, int len) throws JacksonException {
        int dataLen;
        int end;
        int anyNegs;
        if (data == null) {
            this._reportRangeError("Invalid `char[]` argument: `null`");
        }
        if ((anyNegs = offset | len | (end = offset + len) | (dataLen = data.length) - end) < 0) {
            this._reportRangeError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `char[]` of length %d", offset, len, dataLen));
        }
    }

    protected <T> T _reportRangeError(String msg) throws JacksonException {
        throw new StreamReadException((JsonParser)null, msg);
    }

    protected JacksonException _wrapIOFailure(IOException e) {
        return JacksonIOException.construct(e, null);
    }

    protected <T> T _unsupported() {
        return this._unsupported("Operation not supported for this format (%s)", this.getFormatName());
    }

    protected <T> T _unsupported(String str, Object ... args) {
        throw new UnsupportedOperationException(String.format(str, args));
    }

    public static enum Feature implements JacksonFeature
    {
        INTERN_PROPERTY_NAMES(false),
        CANONICALIZE_PROPERTY_NAMES(true),
        FAIL_ON_SYMBOL_HASH_OVERFLOW(true),
        CHARSET_DETECTION(true);

        private final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public boolean enabledIn(int flags) {
            return (flags & this.getMask()) != 0;
        }

        @Override
        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

