/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transaction;

import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class TxnCapability
implements org.apache.qpid.server.protocol.v1_0.type.TxnCapability,
RestrictedType<Symbol> {
    private final Symbol _val;
    public static final TxnCapability LOCAL_TXN = new TxnCapability(Symbol.valueOf("amqp:local-transactions"));
    public static final TxnCapability DISTRIBUTED_TXN = new TxnCapability(Symbol.valueOf("amqp:distributed-transactions"));
    public static final TxnCapability PROMOTABLE_TXN = new TxnCapability(Symbol.valueOf("amqp:promotable-transactions"));
    public static final TxnCapability MULTI_TXNS_PER_SSN = new TxnCapability(Symbol.valueOf("amqp:multi-txns-per-ssn"));
    public static final TxnCapability MULTI_SSNS_PER_TXN = new TxnCapability(Symbol.valueOf("amqp:multi-ssns-per-txn"));

    private TxnCapability(Symbol val) {
        this._val = val;
    }

    @Override
    public Symbol getValue() {
        return this._val;
    }

    public String toString() {
        if (this == LOCAL_TXN) {
            return "local-txn";
        }
        if (this == DISTRIBUTED_TXN) {
            return "distributed-txn";
        }
        if (this == PROMOTABLE_TXN) {
            return "promotable-txn";
        }
        if (this == MULTI_TXNS_PER_SSN) {
            return "multi-txns-per-ssn";
        }
        if (this == MULTI_SSNS_PER_TXN) {
            return "multi-ssns-per-txn";
        }
        return String.valueOf(this._val);
    }

    public static TxnCapability valueOf(Object obj) {
        if (obj instanceof Symbol) {
            Symbol val = (Symbol)obj;
            if (TxnCapability.LOCAL_TXN._val.equals(val)) {
                return LOCAL_TXN;
            }
            if (TxnCapability.DISTRIBUTED_TXN._val.equals(val)) {
                return DISTRIBUTED_TXN;
            }
            if (TxnCapability.PROMOTABLE_TXN._val.equals(val)) {
                return PROMOTABLE_TXN;
            }
            if (TxnCapability.MULTI_TXNS_PER_SSN._val.equals(val)) {
                return MULTI_TXNS_PER_SSN;
            }
            if (TxnCapability.MULTI_SSNS_PER_TXN._val.equals(val)) {
                return MULTI_SSNS_PER_TXN;
            }
        }
        String message = String.format("Cannot convert '%s' into 'txn-capability'", obj);
        throw new IllegalArgumentException(message);
    }
}

