/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.rep.impl.RepConfigManager;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DbCache {
    private final DbCacheLinkedHashMap map;
    private final DbTree dbTree;
    private volatile int maxEntries;
    private volatile int timeoutMs;
    private int tick = 1;
    private long tickTime = System.currentTimeMillis();

    DbCache(DbTree dbTree, int maxEntries, int timeoutMs) {
        assert (dbTree != null);
        this.dbTree = dbTree;
        this.timeoutMs = timeoutMs;
        this.maxEntries = maxEntries;
        this.map = new DbCacheLinkedHashMap();
    }

    public void tick() {
        if (this.timeoutMs > 0 && System.currentTimeMillis() - this.tickTime <= (long)this.timeoutMs) {
            return;
        }
        Iterator vi = this.map.values().iterator();
        while (vi.hasNext()) {
            Info dbInfo = (Info)vi.next();
            if (dbInfo.lastAccess >= this.tick) continue;
            this.release(dbInfo.dbImpl);
            vi.remove();
        }
        ++this.tick;
        this.tickTime = System.currentTimeMillis();
    }

    private void release(DatabaseImpl dbImpl) {
        this.dbTree.releaseDb(dbImpl);
        if (dbImpl.noteWriteHandleClose() == 0) {
            TriggerManager.runCloseTriggers(null, dbImpl);
        }
    }

    public DatabaseImpl get(DatabaseId dbId, Txn txn) {
        Info info = (Info)this.map.get(dbId);
        if (info != null) {
            info.lastAccess = this.tick;
            return info.dbImpl;
        }
        info = new Info(this.dbTree.getDb(dbId, -1L));
        this.map.put(dbId, info);
        if (info.dbImpl.noteWriteHandleOpen() == 1) {
            TriggerManager.runOpenTriggers((Locker)txn, info.dbImpl, false);
        }
        return info.dbImpl;
    }

    public void setConfig(RepConfigManager configMgr) {
        this.maxEntries = configMgr.getInt(RepParams.REPLAY_MAX_OPEN_DB_HANDLES);
        this.timeoutMs = configMgr.getDuration(RepParams.REPLAY_DB_HANDLE_TIMEOUT);
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public void clear() {
        for (Info dbInfo : this.map.values()) {
            this.release(dbInfo.dbImpl);
        }
        this.map.clear();
    }

    LinkedHashMap<DatabaseId, Info> getMap() {
        return this.map;
    }

    private class DbCacheLinkedHashMap
    extends LinkedHashMap<DatabaseId, Info> {
        private DbCacheLinkedHashMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<DatabaseId, Info> eldest) {
            if (this.size() <= DbCache.this.maxEntries) {
                return false;
            }
            DbCache.this.release(eldest.getValue().dbImpl);
            return true;
        }
    }

    private class Info {
        int lastAccess;
        final DatabaseImpl dbImpl;

        public Info(DatabaseImpl dbImpl) {
            this.lastAccess = DbCache.this.tick;
            this.dbImpl = dbImpl;
        }
    }
}

