/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class BooleanConstructor {
    private static final TypeConstructor<Boolean> TRUE_INSTANCE = (in, handler) -> Boolean.TRUE;
    private static final TypeConstructor<Boolean> FALSE_INSTANCE = (in, handler) -> Boolean.FALSE;
    private static final TypeConstructor<Boolean> BYTE_INSTANCE = (in, handler) -> {
        if (in.hasRemaining()) {
            byte b = in.get();
            return b != 0;
        }
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct boolean: insufficient input data", new Object[0]);
    };

    public static TypeConstructor<Boolean> getTrueInstance() {
        return TRUE_INSTANCE;
    }

    public static TypeConstructor<Boolean> getFalseInstance() {
        return FALSE_INSTANCE;
    }

    public static TypeConstructor<Boolean> getByteInstance() {
        return BYTE_INSTANCE;
    }
}

