/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.streams;

import java.util.function.BiConsumer;
import java.util.stream.Collector;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Fluent;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.GenIgnore;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.VertxGen;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.PromiseInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.Pipe;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.StreamBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.WriteStream;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.streams.impl.PipeImpl;

@VertxGen(concrete=false)
public interface ReadStream<T>
extends StreamBase {
    @Override
    public ReadStream<T> exceptionHandler(@Nullable Handler<Throwable> var1);

    @Fluent
    public ReadStream<T> handler(@Nullable Handler<T> var1);

    @Fluent
    public ReadStream<T> pause();

    @Fluent
    public ReadStream<T> resume();

    @Fluent
    public ReadStream<T> fetch(long var1);

    @Fluent
    public ReadStream<T> endHandler(@Nullable Handler<Void> var1);

    default public Pipe<T> pipe() {
        this.pause();
        return new PipeImpl(this);
    }

    default public Future<Void> pipeTo(WriteStream<T> dst) {
        Promise<Void> promise = Promise.promise();
        new PipeImpl<T>(this).to(dst, promise);
        return promise.future();
    }

    default public void pipeTo(WriteStream<T> dst, Handler<AsyncResult<Void>> handler) {
        new PipeImpl<T>(this).to(dst, handler);
    }

    @GenIgnore
    default public <R, A> Future<R> collect(Collector<T, A, R> collector) {
        PromiseInternal promise = (PromiseInternal)Promise.promise();
        Object cumulation = collector.supplier().get();
        BiConsumer accumulator = collector.accumulator();
        this.handler(elt -> accumulator.accept(cumulation, elt));
        this.endHandler(v -> {
            Object result = collector.finisher().apply(cumulation);
            promise.tryComplete(result);
        });
        this.exceptionHandler(promise::tryFail);
        return promise.future();
    }
}

