/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.Iterator;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnLogProposalIterator
implements Iterator<Leader.Proposal> {
    private static final Logger LOG = LoggerFactory.getLogger(TxnLogProposalIterator.class);
    public static final TxnLogProposalIterator EMPTY_ITERATOR = new TxnLogProposalIterator();
    private boolean hasNext = false;
    private TxnLog.TxnIterator itr;

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Leader.Proposal next() {
        Leader.Proposal p;
        try {
            byte[] serializedData = Util.marshallTxnEntry(this.itr.getHeader(), this.itr.getTxn(), this.itr.getDigest());
            QuorumPacket pp = new QuorumPacket(2, this.itr.getHeader().getZxid(), serializedData, null);
            p = new Leader.Proposal(pp);
            this.hasNext = this.itr.next();
        }
        catch (IOException e) {
            LOG.error("Unable to read txnlog from disk", e);
            this.hasNext = false;
            p = new Leader.Proposal();
        }
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.itr != null) {
            try {
                this.itr.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", ioe);
            }
        }
    }

    private TxnLogProposalIterator() {
    }

    public TxnLogProposalIterator(TxnLog.TxnIterator itr) {
        if (itr != null) {
            this.itr = itr;
            this.hasNext = itr.getHeader() != null;
        }
    }
}

