/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka;

import org.apache.pinot.shaded.com.google.common.base.Joiner;

public class KafkaStreamConfigProperties {
    public static final String DOT_SEPARATOR = ".";
    public static final String STREAM_TYPE = "kafka";
    public static final String KAFKA_CONSUMER_PROP_PREFIX = "kafka.consumer.prop";

    private KafkaStreamConfigProperties() {
    }

    public static String constructStreamProperty(String property) {
        return Joiner.on((String)DOT_SEPARATOR).join((Object)"stream", (Object)property, new Object[0]);
    }

    public static class LowLevelConsumer {
        public static final String KAFKA_BROKER_LIST = "kafka.broker.list";
        public static final String KAFKA_BUFFER_SIZE = "kafka.buffer.size";
        public static final int KAFKA_BUFFER_SIZE_DEFAULT = 512000;
        public static final String KAFKA_SOCKET_TIMEOUT = "kafka.socket.timeout";
        public static final int KAFKA_SOCKET_TIMEOUT_DEFAULT = 10000;
        public static final String KAFKA_FETCHER_SIZE_BYTES = "kafka.fetcher.size";
        public static final String KAFKA_FETCHER_MIN_BYTES = "kafka.fetcher.minBytes";
        public static final int KAFKA_FETCHER_MIN_BYTES_DEFAULT = 100000;
        public static final String KAFKA_ISOLATION_LEVEL = "kafka.isolation.level";
        public static final String KAFKA_ISOLATION_LEVEL_READ_COMMITTED = "read_committed";
        public static final String KAFKA_ISOLATION_LEVEL_READ_UNCOMMITTED = "read_uncommitted";
    }

    public static class HighLevelConsumer {
        public static final String KAFKA_HLC_BOOTSTRAP_SERVER = "kafka.hlc.bootstrap.server";
        public static final String KAFKA_HLC_ZK_CONNECTION_STRING = "kafka.hlc.zk.connect.string";
        public static final String ZK_SESSION_TIMEOUT_MS = "zookeeper.session.timeout.ms";
        public static final String ZK_CONNECTION_TIMEOUT_MS = "zookeeper.connection.timeout.ms";
        public static final String ZK_SYNC_TIME_MS = "zookeeper.sync.time.ms";
        public static final String REBALANCE_MAX_RETRIES = "rebalance.max.retries";
        public static final String REBALANCE_BACKOFF_MS = "rebalance.backoff.ms";
        public static final String AUTO_COMMIT_ENABLE = "auto.commit.enable";
        public static final String AUTO_OFFSET_RESET = "auto.offset.reset";
    }
}

