/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kafka.metrics.FilteringJmxReporter;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;

public class KafkaYammerMetrics
implements Reconfigurable {
    public static final KafkaYammerMetrics INSTANCE = new KafkaYammerMetrics();
    private final MetricsRegistry metricsRegistry = new MetricsRegistry();
    private final FilteringJmxReporter jmxReporter = new FilteringJmxReporter(this.metricsRegistry, metricName -> true);

    public static MetricsRegistry defaultRegistry() {
        return KafkaYammerMetrics.INSTANCE.metricsRegistry;
    }

    private KafkaYammerMetrics() {
        this.jmxReporter.start();
        Runtime.getRuntime().addShutdownHook(new Thread(this.jmxReporter::shutdown));
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.reconfigure(configs);
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return JmxReporter.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        JmxReporter.compilePredicate(configs);
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        Predicate<String> mBeanPredicate = JmxReporter.compilePredicate(configs);
        this.jmxReporter.updatePredicate(metricName -> mBeanPredicate.test(metricName.getMBeanName()));
    }
}

