/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import io.grpc.Internal;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.DefaultChannelPromise;
import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

@Internal
public final class ProtectedPromise
extends DefaultChannelPromise {
    private final List<ChannelPromise> unprotectedPromises;
    private int expectedCount;
    private int successfulCount;
    private int failureCount;
    private boolean doneAllocating;

    public ProtectedPromise(Channel channel, EventExecutor executor, int numUnprotectedPromises) {
        super(channel, executor);
        this.unprotectedPromises = new ArrayList<ChannelPromise>(numUnprotectedPromises);
    }

    public void addUnprotectedPromise(ChannelPromise promise) {
        this.unprotectedPromises.add(promise);
    }

    public ChannelPromise newPromise() {
        Preconditions.checkState(!this.doneAllocating, "Done allocating. No more promises can be allocated.");
        ++this.expectedCount;
        return this;
    }

    public ChannelPromise doneAllocatingPromises() {
        if (!this.doneAllocating) {
            this.doneAllocating = true;
            if (this.successfulCount == this.expectedCount) {
                this.trySuccessInternal();
                return super.setSuccess(null);
            }
        }
        return this;
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.awaitingPromises()) {
            ++this.failureCount;
            if (this.failureCount == 1) {
                this.tryFailureInternal(cause);
                return super.tryFailure(cause);
            }
            return true;
        }
        return false;
    }

    @Override
    public ChannelPromise setFailure(Throwable cause) {
        this.tryFailure(cause);
        return this;
    }

    private boolean awaitingPromises() {
        return this.successfulCount + this.failureCount < this.expectedCount;
    }

    @Override
    public ChannelPromise setSuccess(Void unused) {
        this.trySuccess(null);
        return this;
    }

    @Override
    public boolean trySuccess(Void unused) {
        if (this.awaitingPromises()) {
            ++this.successfulCount;
            if (this.successfulCount == this.expectedCount && this.doneAllocating) {
                this.trySuccessInternal();
                return super.trySuccess(null);
            }
            return true;
        }
        return false;
    }

    private void trySuccessInternal() {
        for (int i = 0; i < this.unprotectedPromises.size(); ++i) {
            this.unprotectedPromises.get(i).trySuccess(null);
        }
    }

    private void tryFailureInternal(Throwable cause) {
        for (int i = 0; i < this.unprotectedPromises.size(); ++i) {
            this.unprotectedPromises.get(i).tryFailure(cause);
        }
    }
}

