/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.ExperimentalApi;
import io.grpc.TimeUtils;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

@ThreadSafe
public final class SynchronizationContext
implements Executor {
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicReference<Thread> drainingThread = new AtomicReference();

    public SynchronizationContext(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler, "uncaughtExceptionHandler");
    }

    public final void drain() {
        do {
            if (!this.drainingThread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            try {
                Runnable runnable;
                while ((runnable = this.queue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t2) {
                        this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t2);
                    }
                }
            }
            finally {
                this.drainingThread.set(null);
            }
        } while (!this.queue.isEmpty());
    }

    public final void executeLater(Runnable runnable) {
        this.queue.add(Preconditions.checkNotNull(runnable, "runnable is null"));
    }

    @Override
    public final void execute(Runnable task) {
        this.executeLater(task);
        this.drain();
    }

    public void throwIfNotInThisSynchronizationContext() {
        Preconditions.checkState(Thread.currentThread() == this.drainingThread.get(), "Not called from the SynchronizationContext");
    }

    public final ScheduledHandle schedule(final Runnable task, long delay, TimeUnit unit, ScheduledExecutorService timerService) {
        final ManagedRunnable runnable = new ManagedRunnable(task);
        ScheduledFuture<?> future = timerService.schedule(new Runnable(){

            @Override
            public void run() {
                SynchronizationContext.this.execute(runnable);
            }

            public String toString() {
                return task.toString() + "(scheduled in SynchronizationContext)";
            }
        }, delay, unit);
        return new ScheduledHandle(runnable, future);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11657")
    public final ScheduledHandle schedule(Runnable task, Duration delay, ScheduledExecutorService timerService) {
        return this.schedule(task, TimeUtils.convertToNanos(delay), TimeUnit.NANOSECONDS, timerService);
    }

    public final ScheduledHandle scheduleWithFixedDelay(final Runnable task, long initialDelay, final long delay, TimeUnit unit, ScheduledExecutorService timerService) {
        final ManagedRunnable runnable = new ManagedRunnable(task);
        ScheduledFuture<?> future = timerService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SynchronizationContext.this.execute(runnable);
            }

            public String toString() {
                return task.toString() + "(scheduled in SynchronizationContext with delay of " + delay + ")";
            }
        }, initialDelay, delay, unit);
        return new ScheduledHandle(runnable, future);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11657")
    public final ScheduledHandle scheduleWithFixedDelay(Runnable task, Duration initialDelay, Duration delay, ScheduledExecutorService timerService) {
        return this.scheduleWithFixedDelay(task, TimeUtils.convertToNanos(initialDelay), TimeUtils.convertToNanos(delay), TimeUnit.NANOSECONDS, timerService);
    }

    public static final class ScheduledHandle {
        private final ManagedRunnable runnable;
        private final ScheduledFuture<?> future;

        private ScheduledHandle(ManagedRunnable runnable, ScheduledFuture<?> future) {
            this.runnable = Preconditions.checkNotNull(runnable, "runnable");
            this.future = Preconditions.checkNotNull(future, "future");
        }

        public void cancel() {
            this.runnable.isCancelled = true;
            this.future.cancel(false);
        }

        public boolean isPending() {
            return !this.runnable.hasStarted && !this.runnable.isCancelled;
        }
    }

    private static class ManagedRunnable
    implements Runnable {
        final Runnable task;
        boolean isCancelled;
        boolean hasStarted;

        ManagedRunnable(Runnable task) {
            this.task = Preconditions.checkNotNull(task, "task");
        }

        @Override
        public void run() {
            if (!this.isCancelled) {
                this.hasStarted = true;
                this.task.run();
            }
        }
    }
}

