/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.storage.BaseStorageReadChannel;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.storage.GapicDownloadSessionBuilder;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.LazyReadChannel;
import com.google.cloud.storage.ReadableByteChannelSession;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.Retrying;
import com.google.storage.v2.Object;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GrpcBlobReadChannel
extends BaseStorageReadChannel<Object> {
    private final GrpcUtils.ZeroCopyServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
    private final Retrying.Retrier retrier;
    private final ResultRetryAlgorithm<?> resultRetryAlgorithm;
    private final ReadObjectRequest request;
    private final boolean autoGzipDecompression;

    GrpcBlobReadChannel(GrpcUtils.ZeroCopyServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, Retrying.Retrier retrier, ResultRetryAlgorithm<?> resultRetryAlgorithm, ReadObjectRequest request, boolean autoGzipDecompression) {
        super(Conversions.grpc().blobInfo());
        this.read = read;
        this.retrier = retrier;
        this.resultRetryAlgorithm = resultRetryAlgorithm;
        this.request = request;
        this.autoGzipDecompression = autoGzipDecompression;
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        return (RestorableState)CrossTransportUtils.throwHttpJsonOnly(ReadChannel.class, "capture");
    }

    @Override
    protected LazyReadChannel<?, Object> newLazyReadChannel() {
        return new LazyReadChannel(() -> {
            GapicDownloadSessionBuilder.ReadableByteChannelSessionBuilder b = ResumableMedia.gapic().read().byteChannel(this.read, this.retrier, this.resultRetryAlgorithm).setHasher(Hasher.noop()).setAutoGzipDecompression(this.autoGzipDecompression);
            BufferHandle bufferHandle = this.getBufferHandle();
            ReadableByteChannelSession session = bufferHandle.capacity() > 0 ? b.buffered(this.getBufferHandle()).setReadObjectRequest(this.getReadObjectRequest()).build() : b.unbuffered().setReadObjectRequest(this.getReadObjectRequest()).build();
            return session;
        });
    }

    private @NonNull ReadObjectRequest getReadObjectRequest() {
        Object resolvedObject;
        ByteRangeSpec rangeSpec = this.getByteRangeSpec();
        ReadObjectRequest.Builder b = this.request.toBuilder();
        if (this.request.getGeneration() == 0L && (resolvedObject = (Object)this.getResolvedObject()) != null) {
            b.setGeneration(resolvedObject.getGeneration());
        }
        return rangeSpec.seekReadObjectRequest(b).build();
    }
}

