/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.ExternalAccountSupplierContext;
import com.google.auth.oauth2.IdentityPoolCredentialSource;
import com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import com.google.auth.oauth2.OAuth2Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.base.Strings;

public class CertificateIdentityPoolSubjectTokenSupplier
implements IdentityPoolSubjectTokenSupplier {
    private final IdentityPoolCredentialSource credentialSource;
    private static final Pattern PEM_CERT_PATTERN = Pattern.compile("-----BEGIN CERTIFICATE-----.*?-----END CERTIFICATE-----", 32);

    CertificateIdentityPoolSubjectTokenSupplier(IdentityPoolCredentialSource credentialSource) {
        this.credentialSource = Preconditions.checkNotNull(credentialSource, "credentialSource cannot be null");
        Preconditions.checkNotNull(credentialSource.getCertificateConfig(), "credentialSource.certificateConfig cannot be null when creating CertificateIdentityPoolSubjectTokenSupplier");
    }

    private static String loadAndEncodeLeafCertificate(String path) throws IOException {
        try {
            byte[] leafCertBytes = Files.readAllBytes(Paths.get(path, new String[0]));
            X509Certificate leafCert = CertificateIdentityPoolSubjectTokenSupplier.parseCertificate(leafCertBytes);
            return CertificateIdentityPoolSubjectTokenSupplier.encodeCert(leafCert);
        }
        catch (NoSuchFileException e) {
            throw new IOException(String.format("Leaf certificate file not found: %s", path), e);
        }
        catch (CertificateException e) {
            throw new IOException(String.format("Failed to parse leaf certificate from file: %s", path), e);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to read leaf certificate file: %s", path), e);
        }
    }

    @VisibleForTesting
    static X509Certificate parseCertificate(byte[] certData) throws CertificateException {
        if (certData == null || certData.length == 0) {
            throw new IllegalArgumentException("Invalid certificate data: Certificate file is empty or null.");
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream certificateStream = new ByteArrayInputStream(certData);
            return (X509Certificate)certificateFactory.generateCertificate(certificateStream);
        }
        catch (CertificateException e) {
            throw new CertificateException("Failed to parse X.509 certificate data.", e);
        }
    }

    private static String encodeCert(X509Certificate certificate) throws CertificateEncodingException {
        return Base64.getEncoder().encodeToString(certificate.getEncoded());
    }

    @Override
    public String getSubjectToken(ExternalAccountSupplierContext context) throws IOException {
        String leafCertPath = this.credentialSource.getCredentialLocation();
        String trustChainPath = null;
        if (this.credentialSource.getCertificateConfig() != null) {
            trustChainPath = this.credentialSource.getCertificateConfig().getTrustChainPath();
        }
        String encodedLeafCert = CertificateIdentityPoolSubjectTokenSupplier.loadAndEncodeLeafCertificate(leafCertPath);
        ArrayList<String> certChain = new ArrayList<String>();
        certChain.add(encodedLeafCert);
        try {
            List<X509Certificate> trustChainCerts = CertificateIdentityPoolSubjectTokenSupplier.readTrustChain(trustChainPath);
            if (!trustChainCerts.isEmpty()) {
                this.populateCertChainFromTrustChain(certChain, trustChainCerts, encodedLeafCert);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Trust chain misconfiguration: " + e.getMessage(), e);
        }
        catch (NoSuchFileException e) {
            throw new IOException(String.format("Trust chain file not found: %s", trustChainPath), e);
        }
        catch (CertificateException e) {
            throw new IOException(String.format("Failed to parse certificate(s) from trust chain file: %s", trustChainPath), e);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to read trust chain file: %s", trustChainPath), e);
        }
        return OAuth2Utils.JSON_FACTORY.toString(certChain);
    }

    private void populateCertChainFromTrustChain(List<String> certChainToPopulate, List<X509Certificate> trustChainCerts, String encodedLeafCert) throws CertificateEncodingException, IllegalArgumentException {
        X509Certificate firstTrustCert = trustChainCerts.get(0);
        String encodedFirstTrustCert = CertificateIdentityPoolSubjectTokenSupplier.encodeCert(firstTrustCert);
        if (!encodedFirstTrustCert.equals(encodedLeafCert)) {
            certChainToPopulate.add(encodedFirstTrustCert);
        }
        for (int i = 1; i < trustChainCerts.size(); ++i) {
            X509Certificate currentCert = trustChainCerts.get(i);
            String encodedCurrentCert = CertificateIdentityPoolSubjectTokenSupplier.encodeCert(currentCert);
            if (encodedCurrentCert.equals(encodedLeafCert)) {
                throw new IllegalArgumentException("The leaf certificate should only appear at the beginning of the trust chain file, or be omitted entirely.");
            }
            certChainToPopulate.add(encodedCurrentCert);
        }
    }

    @VisibleForTesting
    static List<X509Certificate> readTrustChain(String trustChainPath) throws IOException, CertificateException {
        ArrayList<X509Certificate> certificateTrustChain = new ArrayList<X509Certificate>();
        if (Strings.isNullOrEmpty(trustChainPath)) {
            return certificateTrustChain;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        byte[] trustChainData = Files.readAllBytes(Paths.get(trustChainPath, new String[0]));
        String content = new String(trustChainData, StandardCharsets.UTF_8);
        Matcher matcher = PEM_CERT_PATTERN.matcher(content);
        while (matcher.find()) {
            String pemCertBlock = matcher.group(0);
            try {
                ByteArrayInputStream certStream = new ByteArrayInputStream(pemCertBlock.getBytes(StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    Certificate cert = cf.generateCertificate(certStream);
                    if (cert instanceof X509Certificate) {
                        certificateTrustChain.add((X509Certificate)cert);
                        continue;
                    }
                    throw new CertificateException("Found non-X.509 certificate in trust chain file: " + trustChainPath);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (certStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)certStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)certStream).close();
                }
            }
            catch (CertificateException e) {
                throw new CertificateException("Error loading PEM certificates from the trust chain file: " + trustChainPath + " - " + e.getMessage(), e);
            }
        }
        if (trustChainData.length > 0 && certificateTrustChain.isEmpty()) {
            throw new CertificateException("Trust chain file was not empty but no PEM certificates were found: " + trustChainPath);
        }
        return certificateTrustChain;
    }
}

