/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientConnect;
import reactor.netty.http.client.HttpClientFinalizer;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

final class WebsocketFinalizer
extends HttpClientConnect
implements HttpClient.WebsocketSender {
    WebsocketFinalizer(HttpClientConfig config) {
        super(config);
    }

    @Override
    public HttpClient.WebsocketSender uri(Mono<String> uri) {
        Objects.requireNonNull(uri, "uri");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).deferredConf(config -> uri.map(s -> {
            config.uriStr = s;
            config.uri = null;
            return config;
        }));
        return (WebsocketFinalizer)dup;
    }

    @Override
    public HttpClient.WebsocketSender uri(String uri) {
        Objects.requireNonNull(uri, "uri");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).uriStr = uri;
        ((HttpClientConfig)dup.configuration()).uri = null;
        return (WebsocketFinalizer)dup;
    }

    @Override
    public HttpClient.WebsocketSender uri(URI uri) {
        Objects.requireNonNull(uri, "uri");
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute: " + uri);
        }
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).uriStr = null;
        ((HttpClientConfig)dup.configuration()).uri = uri;
        return (WebsocketFinalizer)dup;
    }

    public WebsocketFinalizer send(Function<? super HttpClientRequest, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).body = (req, out) -> (Publisher)sender.apply((HttpClientRequest)req);
        return (WebsocketFinalizer)dup;
    }

    @Override
    public Mono<? extends Connection> connect() {
        return super.connect();
    }

    @Override
    public <V> Flux<V> handle(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<V>> receiver) {
        Mono<? extends Connection> connector = this.connect();
        return connector.flatMapMany(c -> Flux.from((Publisher)receiver.apply((WebsocketInbound)c, (WebsocketOutbound)c)).doFinally(s -> HttpClientFinalizer.discard(c)));
    }

    @Override
    public ByteBufFlux receive() {
        ByteBufAllocator alloc = (ByteBufAllocator)this.configuration().options().get(ChannelOption.ALLOCATOR);
        if (alloc == null) {
            alloc = ByteBufAllocator.DEFAULT;
        }
        Mono<? extends Connection> connector = this.connect();
        return ByteBufFlux.fromInbound(connector.flatMapMany(HttpClientFinalizer.contentReceiver), alloc);
    }

    @Override
    protected HttpClient duplicate() {
        return new WebsocketFinalizer(new HttpClientConfig(this.config));
    }
}

