/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.PageBlobsClearPagesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCopyIncrementalHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesDiffHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsResizeHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUpdateSequenceNumberHeaders;
import com.azure.storage.blob.implementation.models.PageListHelper;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ClearRange;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.PageBlobCopyIncrementalRequestConditions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.PageRangeItem;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.options.ListPageRangesDiffOptions;
import com.azure.storage.blob.options.ListPageRangesOptions;
import com.azure.storage.blob.options.PageBlobCopyIncrementalOptions;
import com.azure.storage.blob.options.PageBlobCreateOptions;
import com.azure.storage.blob.options.PageBlobUploadPagesFromUrlOptions;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.PageBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SpecializedBlobClientBuilder.class)
public final class PageBlobClient
extends BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(PageBlobClient.class);
    private final PageBlobAsyncClient pageBlobAsyncClient;
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    PageBlobClient(PageBlobAsyncClient pageBlobAsyncClient) {
        this(pageBlobAsyncClient, pageBlobAsyncClient.getHttpPipeline(), pageBlobAsyncClient.getAccountUrl(), pageBlobAsyncClient.getServiceVersion(), pageBlobAsyncClient.getAccountName(), pageBlobAsyncClient.getContainerName(), pageBlobAsyncClient.getBlobName(), pageBlobAsyncClient.getSnapshotId(), pageBlobAsyncClient.getCustomerProvidedKey(), new EncryptionScope().setEncryptionScope(pageBlobAsyncClient.getEncryptionScope()), pageBlobAsyncClient.getVersionId());
    }

    PageBlobClient(PageBlobAsyncClient pageBlobAsyncClient, HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pageBlobAsyncClient, pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
        this.pageBlobAsyncClient = pageBlobAsyncClient;
    }

    @Override
    public PageBlobClient getEncryptionScopeClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        PageBlobAsyncClient asyncClient = this.pageBlobAsyncClient.getEncryptionScopeAsyncClient(encryptionScope);
        return new PageBlobClient(asyncClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public PageBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        PageBlobAsyncClient asyncClient = this.pageBlobAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey);
        return new PageBlobClient(asyncClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    public BlobOutputStream getBlobOutputStream(PageRange pageRange) {
        return this.getBlobOutputStream(pageRange, null);
    }

    public BlobOutputStream getBlobOutputStream(PageRange pageRange, BlobRequestConditions requestConditions) {
        return BlobOutputStream.pageBlobOutputStream(this.pageBlobAsyncClient, pageRange, requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem create(long size) {
        return this.create(size, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem create(long size, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(size, null, null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> createWithResponse(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return this.createWithResponse(new PageBlobCreateOptions(size).setSequenceNumber(sequenceNumber).setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> createWithResponse(PageBlobCreateOptions options, Duration timeout, Context context) {
        BlobRequestConditions requestConditions;
        StorageImplUtils.assertNotNull("options", options);
        Context finalContext = context == null ? Context.NONE : context;
        BlobRequestConditions blobRequestConditions = requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        if (options.getSize() % 512L != 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        if (options.getSequenceNumber() != null && options.getSequenceNumber() < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        BlobImmutabilityPolicy immutabilityPolicy = options.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : options.getImmutabilityPolicy();
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().createWithResponse(this.containerName, this.blobName, 0L, options.getSize(), null, null, options.getMetadata(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), options.getSequenceNumber(), null, ModelHelper.tagsToString(options.getTags()), immutabilityPolicy.getExpiryTime(), immutabilityPolicy.getPolicyMode(), options.isLegalHold(), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        PageBlobsCreateHeaders hd = (PageBlobsCreateHeaders)response.getDeserializedHeaders();
        PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null, hd.getXMsVersionId());
        return new SimpleResponse<PageBlobItem>(response, item);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem createIfNotExists(long size) {
        return this.createIfNotExistsWithResponse(new PageBlobCreateOptions(size), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> createIfNotExistsWithResponse(PageBlobCreateOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        options.setRequestConditions(new BlobRequestConditions().setIfNoneMatch("*").setIfNoneMatch("*"));
        try {
            return this.createWithResponse(options, timeout, context);
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 409) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Object>(res.getRequest(), res.getStatusCode(), res.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError(e);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem uploadPages(PageRange pageRange, InputStream body) {
        return this.uploadPagesWithResponse(pageRange, body, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> uploadPagesWithResponse(PageRange pageRange, InputStream body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions, Duration timeout, Context context) {
        Objects.requireNonNull(body, "'body' cannot be null.");
        long length = pageRange.getEnd() - pageRange.getStart() + 1L;
        Flux<ByteBuffer> fbb = Utility.convertStreamToByteBuffer(body, length, 512, true);
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.uploadPagesWithResponse(pageRange, fbb, contentMd5, pageBlobRequestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem uploadPagesFromUrl(PageRange range, String sourceUrl, Long sourceOffset) {
        return this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions, Duration timeout, Context context) {
        return this.uploadPagesFromUrlWithResponse(new PageBlobUploadPagesFromUrlOptions(range, sourceUrl).setSourceOffset(sourceOffset).setSourceContentMd5(sourceContentMd5).setDestinationRequestConditions(destRequestConditions).setSourceRequestConditions(sourceRequestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> uploadPagesFromUrlWithResponse(PageBlobUploadPagesFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<PageBlobItem>> response = this.pageBlobAsyncClient.uploadPagesFromUrlWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem clearPages(PageRange pageRange) {
        return this.clearPagesWithResponse(pageRange, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions, Duration timeout, Context context) {
        PageBlobRequestConditions finalPageBlobRequestConditions;
        PageBlobRequestConditions pageBlobRequestConditions2 = finalPageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = ModelHelper.pageRangeToString(pageRange);
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().clearPagesWithResponse(this.containerName, this.blobName, 0L, null, pageRangeStr, finalPageBlobRequestConditions.getLeaseId(), finalPageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), finalPageBlobRequestConditions.getIfSequenceNumberLessThan(), finalPageBlobRequestConditions.getIfSequenceNumberEqualTo(), finalPageBlobRequestConditions.getIfModifiedSince(), finalPageBlobRequestConditions.getIfUnmodifiedSince(), finalPageBlobRequestConditions.getIfMatch(), finalPageBlobRequestConditions.getIfNoneMatch(), finalPageBlobRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        PageBlobsClearPagesHeaders hd = (PageBlobsClearPagesHeaders)response.getDeserializedHeaders();
        PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), null, hd.getXMsBlobSequenceNumber());
        return new SimpleResponse<PageBlobItem>(response, item);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageList getPageRanges(BlobRange blobRange) {
        return this.getPageRangesWithResponse(blobRange, null, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageList> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRange finalBlobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().getPageRangesWithResponse(this.containerName, this.blobName, this.getSnapshotId(), null, finalBlobRange.toHeaderValue(), finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, null, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        return new SimpleResponse<PageList>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (PageList)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedIterable<PageRangeItem> listPageRanges(BlobRange blobRange) {
        return this.listPageRanges(new ListPageRangesOptions(blobRange), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedIterable<PageRangeItem> listPageRanges(ListPageRangesOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options, "options must not be null");
        Context finalContext = context == null ? Context.NONE : context;
        BiFunction pageRetriever = (continuationToken, pageSize) -> {
            BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
            Integer finalPageSize = pageSize == null ? options.getMaxResultsPerPage() : pageSize;
            Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().getPageRangesWithResponse(this.containerName, this.blobName, this.getSnapshotId(), null, options.getRange().toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, (String)continuationToken, finalPageSize, finalContext);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
            List<PageRangeItem> value = this.parsePageRangeItems((PageList)response.getValue());
            return new PagedResponseBase<PageBlobsGetPageRangesHeaders, PageRangeItem>(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, PageListHelper.getNextMarker((PageList)response.getValue()), (PageBlobsGetPageRangesHeaders)response.getDeserializedHeaders());
        };
        return new PagedIterable<PageRangeItem>(pageSize -> (PagedResponse)pageRetriever.apply((String)null, (Integer)pageSize), pageRetriever);
    }

    private List<PageRangeItem> parsePageRangeItems(PageList pageList) {
        if (pageList == null) {
            return Collections.emptyList();
        }
        return Stream.concat(pageList.getPageRange().stream().map(this::toPageBlobRange), pageList.getClearRange().stream().map(this::toPageBlobRange)).collect(Collectors.toList());
    }

    private PageRangeItem toPageBlobRange(PageRange range) {
        return new PageRangeItem(new HttpRange(range.getStart(), range.getEnd() - range.getStart() + 1L), false);
    }

    private PageRangeItem toPageBlobRange(ClearRange range) {
        return new PageRangeItem(new HttpRange(range.getStart(), range.getEnd() - range.getStart() + 1L), true);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageList getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageList> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions;
        BlobRange finalBlobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        BlobRequestConditions blobRequestConditions = finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (prevSnapshot == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("prevSnapshot cannot be null"));
        }
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().getPageRangesDiffWithResponse(this.containerName, this.blobName, this.getSnapshotId(), null, prevSnapshot, null, finalBlobRange.toHeaderValue(), finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, null, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        return new SimpleResponse<PageList>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (PageList)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedIterable<PageRangeItem> listPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.listPageRangesDiff(new ListPageRangesDiffOptions(blobRange, prevSnapshot), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedIterable<PageRangeItem> listPageRangesDiff(ListPageRangesDiffOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options, "options must not be null");
        Context finalContext = context == null ? Context.NONE : context;
        BiFunction pageRetriever = (continuationToken, pageSize) -> {
            BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
            Integer finalPageSize = pageSize != null ? pageSize : options.getMaxResultsPerPage();
            Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().getPageRangesDiffWithResponse(this.containerName, this.blobName, this.getSnapshotId(), null, options.getPreviousSnapshot(), null, options.getRange().toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, (String)continuationToken, finalPageSize, finalContext);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
            List<PageRangeItem> value = this.parsePageRangeItems((PageList)response.getValue());
            return new PagedResponseBase<PageBlobsGetPageRangesDiffHeaders, PageRangeItem>(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, PageListHelper.getNextMarker((PageList)response.getValue()), (PageBlobsGetPageRangesDiffHeaders)response.getDeserializedHeaders());
        };
        return new PagedIterable<PageRangeItem>(pageSize -> (PagedResponse)pageRetriever.apply((String)null, (Integer)pageSize), pageRetriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageList getManagedDiskPageRangesDiff(BlobRange blobRange, String prevSnapshotUrl) {
        return this.getManagedDiskPageRangesDiffWithResponse(blobRange, prevSnapshotUrl, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageList> getManagedDiskPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshotUrl, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobRequestConditions finalRequestConditions;
        BlobRange finalBlobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        BlobRequestConditions blobRequestConditions = finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (prevSnapshotUrl == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("prevSnapshot cannot be null"));
        }
        try {
            new URL(prevSnapshotUrl);
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'prevSnapshotUrl' is not a valid url.", ex));
        }
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().getPageRangesDiffWithResponse(this.containerName, this.blobName, this.getSnapshotId(), null, null, prevSnapshotUrl, finalBlobRange.toHeaderValue(), finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, null, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        return new SimpleResponse<PageList>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (PageList)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem resize(long size) {
        return this.resizeWithResponse(size, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> resizeWithResponse(long size, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        if (size % 512L != 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().resizeWithResponse(this.containerName, this.blobName, size, null, finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        PageBlobsResizeHeaders hd = (PageBlobsResizeHeaders)response.getDeserializedHeaders();
        PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getXMsBlobSequenceNumber());
        return new SimpleResponse<PageBlobItem>(response, item);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PageBlobItem updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return this.updateSequenceNumberWithResponse(action, sequenceNumber, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PageBlobItem> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        Long finalSequenceNumber = action == SequenceNumberActionType.INCREMENT ? null : sequenceNumber;
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().updateSequenceNumberWithResponse(this.containerName, this.blobName, action, null, finalRequestConditions.getLeaseId(), finalRequestConditions.getIfModifiedSince(), finalRequestConditions.getIfUnmodifiedSince(), finalRequestConditions.getIfMatch(), finalRequestConditions.getIfNoneMatch(), finalRequestConditions.getTagsConditions(), finalSequenceNumber, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        PageBlobsUpdateSequenceNumberHeaders hd = (PageBlobsUpdateSequenceNumberHeaders)response.getDeserializedHeaders();
        PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getXMsBlobSequenceNumber());
        return new SimpleResponse<PageBlobItem>(response, item);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyStatusType copyIncremental(String source, String snapshot) {
        return this.copyIncrementalWithResponse(source, snapshot, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyStatusType> copyIncrementalWithResponse(String source, String snapshot, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.copyIncrementalWithResponse(new PageBlobCopyIncrementalOptions(source, snapshot).setRequestConditions(ModelHelper.populateBlobDestinationRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyStatusType> copyIncrementalWithResponse(PageBlobCopyIncrementalOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        UrlBuilder builder = UrlBuilder.parse(options.getSource());
        builder.setQueryParameter("snapshot", options.getSnapshot());
        PageBlobCopyIncrementalRequestConditions modifiedRequestConditions = options.getRequestConditions() == null ? new PageBlobCopyIncrementalRequestConditions() : options.getRequestConditions();
        try {
            builder.toUrl();
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(e));
        }
        Context finalContext = context == null ? Context.NONE : context;
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getPageBlobs().copyIncrementalWithResponse(this.containerName, this.blobName, builder.toString(), null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), modifiedRequestConditions.getTagsConditions(), null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        return new SimpleResponse<CopyStatusType>(response, ((PageBlobsCopyIncrementalHeaders)response.getDeserializedHeaders()).getXMsCopyStatus());
    }
}

