/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.logging;

import com.azure.core.implementation.StringBuilderWriter;
import com.azure.core.implementation.util.EnvironmentConfiguration;
import com.azure.core.util.logging.LogLevel;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class DefaultLogger
implements Logger {
    private static final String WHITESPACE = " ";
    private static final String HYPHEN = " - ";
    private static final String OPEN_BRACKET = " [";
    private static final String CLOSE_BRACKET = "]";
    public static final String WARN = "WARN";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String ERROR = "ERROR";
    public static final String TRACE = "TRACE";
    private final String classPath;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;
    private final PrintStream logLocation;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getCanonicalName(), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String className) {
        this(DefaultLogger.getClassPathFromClassName(className), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String className, PrintStream logLocation, LogLevel logLevel) {
        this.classPath = DefaultLogger.getClassPathFromClassName(className);
        int configuredLogLevel = logLevel.getLogLevel();
        this.isTraceEnabled = LogLevel.VERBOSE.getLogLevel() > configuredLogLevel;
        this.isDebugEnabled = LogLevel.VERBOSE.getLogLevel() >= configuredLogLevel;
        this.isInfoEnabled = LogLevel.INFORMATIONAL.getLogLevel() >= configuredLogLevel;
        this.isWarnEnabled = LogLevel.WARNING.getLogLevel() >= configuredLogLevel;
        this.isErrorEnabled = LogLevel.ERROR.getLogLevel() >= configuredLogLevel;
        this.logLocation = logLocation;
    }

    private static String getClassPathFromClassName(String className) {
        try {
            return Class.forName(className).getCanonicalName();
        }
        catch (ClassNotFoundException | InvalidPathException e) {
            return className;
        }
    }

    private static LogLevel fromEnvironment() {
        String level = EnvironmentConfiguration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        return LogLevel.fromString(level);
    }

    @Override
    public String getName() {
        return this.classPath;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public void trace(String msg) {
        this.logMessageWithFormat(TRACE, msg, new Object[0]);
    }

    @Override
    public void trace(String format, Object arg1) {
        this.logMessageWithFormat(TRACE, format, arg1);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(TRACE, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logMessageWithFormat(TRACE, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(TRACE, msg, t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    @Override
    public void trace(Marker marker, String s) {
        this.trace(s);
    }

    @Override
    public void trace(Marker marker, String s, Object o) {
        this.trace(s, o);
    }

    @Override
    public void trace(Marker marker, String s, Object o, Object o1) {
        this.trace(s, o, o1);
    }

    @Override
    public void trace(Marker marker, String s, Object ... objects) {
        this.trace(s, objects);
    }

    @Override
    public void trace(Marker marker, String s, Throwable throwable) {
        this.trace(s, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public void debug(String msg) {
        this.logMessageWithFormat(DEBUG, msg, new Object[0]);
    }

    @Override
    public void debug(String format, Object arg) {
        this.logMessageWithFormat(DEBUG, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(DEBUG, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.logMessageWithFormat(DEBUG, format, args);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(DEBUG, msg, t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    @Override
    public void debug(Marker marker, String s) {
        this.debug(s);
    }

    @Override
    public void debug(Marker marker, String s, Object o) {
        this.debug(s, o);
    }

    @Override
    public void debug(Marker marker, String s, Object o, Object o1) {
        this.debug(s, o, o1);
    }

    @Override
    public void debug(Marker marker, String s, Object ... objects) {
        this.debug(s, objects);
    }

    @Override
    public void debug(Marker marker, String s, Throwable throwable) {
        this.debug(s, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    @Override
    public void info(String msg) {
        this.logMessageWithFormat(INFO, msg, new Object[0]);
    }

    @Override
    public void info(String format, Object arg) {
        this.logMessageWithFormat(INFO, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(INFO, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... args) {
        this.logMessageWithFormat(INFO, format, args);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(INFO, msg, t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    @Override
    public void info(Marker marker, String s) {
        this.info(s);
    }

    @Override
    public void info(Marker marker, String s, Object o) {
        this.info(s, o);
    }

    @Override
    public void info(Marker marker, String s, Object o, Object o1) {
        this.info(s, o, o1);
    }

    @Override
    public void info(Marker marker, String s, Object ... objects) {
        this.info(s, objects);
    }

    @Override
    public void info(Marker marker, String s, Throwable throwable) {
        this.info(s, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    @Override
    public void warn(String msg) {
        this.logMessageWithFormat(WARN, msg, new Object[0]);
    }

    @Override
    public void warn(String format, Object arg) {
        this.logMessageWithFormat(WARN, format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(WARN, format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.logMessageWithFormat(WARN, format, args);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(WARN, msg, t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    @Override
    public void warn(Marker marker, String s) {
        this.warn(s);
    }

    @Override
    public void warn(Marker marker, String s, Object o) {
        this.warn(s, o);
    }

    @Override
    public void warn(Marker marker, String s, Object o, Object o1) {
        this.warn(s, o, o1);
    }

    @Override
    public void warn(Marker marker, String s, Object ... objects) {
        this.warn(s, objects);
    }

    @Override
    public void warn(Marker marker, String s, Throwable throwable) {
        this.warn(s, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    @Override
    public void error(String format, Object arg) {
        this.logMessageWithFormat(ERROR, format, arg);
    }

    @Override
    public void error(String msg) {
        this.logMessageWithFormat(ERROR, msg, new Object[0]);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(ERROR, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... args) {
        this.logMessageWithFormat(ERROR, format, args);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(ERROR, msg, t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    @Override
    public void error(Marker marker, String s) {
        this.error(s);
    }

    @Override
    public void error(Marker marker, String s, Object o) {
        this.error(s, o);
    }

    @Override
    public void error(Marker marker, String s, Object o, Object o1) {
        this.error(s, o, o1);
    }

    @Override
    public void error(Marker marker, String s, Object ... objects) {
        this.error(s, objects);
    }

    @Override
    public void error(Marker marker, String s, Throwable throwable) {
        this.error(s, throwable);
    }

    private void logMessageWithFormat(String levelName, String format, Object ... arguments) {
        FormattingTuple tp = MessageFormatter.arrayFormat(format, arguments);
        this.log(levelName, tp.getMessage(), tp.getThrowable());
    }

    private void log(String levelName, String message, Throwable t) {
        String dateTime = DefaultLogger.getFormattedDate();
        String threadName = Thread.currentThread().getName();
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(dateTime).append(OPEN_BRACKET).append(threadName).append(CLOSE_BRACKET).append(OPEN_BRACKET).append(levelName).append(CLOSE_BRACKET).append(WHITESPACE).append(this.classPath).append(HYPHEN).append(message).append(System.lineSeparator());
        this.writeWithThrowable(stringBuilder, t);
    }

    private static String getFormattedDate() {
        LocalDateTime now = LocalDateTime.now();
        byte[] bytes = new byte[23];
        int year = now.getYear();
        int round = year / 1000;
        bytes[0] = (byte)(48 + round);
        year -= 1000 * round;
        round = year / 100;
        bytes[1] = (byte)(48 + round);
        year -= 100 * round;
        round = year / 10;
        bytes[2] = (byte)(48 + round);
        bytes[3] = (byte)(48 + (year - 10 * round));
        bytes[4] = 45;
        DefaultLogger.zeroPad(now.getMonthValue(), bytes, 5);
        bytes[7] = 45;
        DefaultLogger.zeroPad(now.getDayOfMonth(), bytes, 8);
        bytes[10] = 32;
        DefaultLogger.zeroPad(now.getHour(), bytes, 11);
        bytes[13] = 58;
        DefaultLogger.zeroPad(now.getMinute(), bytes, 14);
        bytes[16] = 58;
        DefaultLogger.zeroPad(now.getSecond(), bytes, 17);
        bytes[19] = 46;
        int millis = now.get(ChronoField.MILLI_OF_SECOND);
        round = millis / 100;
        bytes[20] = (byte)(48 + round);
        millis -= 100 * round;
        round = millis / 10;
        bytes[21] = (byte)(48 + round);
        bytes[22] = (byte)(48 + (millis - 10 * round));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    void writeWithThrowable(StringBuilder stringBuilder, Throwable t) {
        if (t != null) {
            StringBuilderWriter sw = new StringBuilderWriter(stringBuilder);
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
            }
        }
        this.logLocation.print(stringBuilder.toString());
    }

    private static void zeroPad(int value, byte[] bytes, int index) {
        if (value < 10) {
            bytes[index++] = 48;
            bytes[index] = (byte)(48 + value);
        } else {
            int high = value / 10;
            bytes[index++] = (byte)(48 + high);
            bytes[index] = (byte)(48 + (value - 10 * high));
        }
    }
}

