/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class TxnOffsetCommitResponse
extends AbstractResponse {
    private final TxnOffsetCommitResponseData data;

    public TxnOffsetCommitResponse(TxnOffsetCommitResponseData data) {
        super(ApiKeys.TXN_OFFSET_COMMIT);
        this.data = data;
    }

    public TxnOffsetCommitResponse(int requestThrottleMs, Map<TopicPartition, Errors> responseData) {
        super(ApiKeys.TXN_OFFSET_COMMIT);
        HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> responseTopicDataMap = new HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>();
        for (Map.Entry<TopicPartition, Errors> entry : responseData.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic = responseTopicDataMap.getOrDefault(topicName, new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicName));
            topic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition()));
            responseTopicDataMap.put(topicName, topic);
        }
        this.data = new TxnOffsetCommitResponseData().setTopics(new ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>(responseTopicDataMap.values())).setThrottleTimeMs(requestThrottleMs);
    }

    @Override
    public TxnOffsetCommitResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.data.topics().stream().flatMap(topic -> topic.partitions().stream().map(partition2 -> Errors.forCode(partition2.errorCode()))));
    }

    public Map<TopicPartition, Errors> errors() {
        HashMap<TopicPartition, Errors> errorMap = new HashMap<TopicPartition, Errors>();
        for (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic : this.data.topics()) {
            for (TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition partition2 : topic.partitions()) {
                errorMap.put(new TopicPartition(topic.name(), partition2.partitionIndex()), Errors.forCode(partition2.errorCode()));
            }
        }
        return errorMap;
    }

    public static TxnOffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitResponse(new TxnOffsetCommitResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

