/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.subject.DefaultReferenceSubjectNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class KafkaProtobufSerializerConfig
extends AbstractKafkaSchemaSerDeConfig {
    public static final String REFERENCE_LOOKUP_ONLY_CONFIG = "reference.lookup.only";
    public static final String REFERENCE_LOOKUP_ONLY_DOC = "Regardless of whether auto.register.schemas or use.latest.version is true, only look up the ID for references by using the schema.";
    public static final String SKIP_KNOWN_TYPES_CONFIG = "skip.known.types";
    public static final String SKIP_KNOWN_TYPES_DOC = "Whether to skip known types when resolving schema dependencies.";
    public static final String REFERENCE_SUBJECT_NAME_STRATEGY_CONFIG = "reference.subject.name.strategy";
    public static final String REFERENCE_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name for referenced schemas. By default, the reference name is used as subject.";
    private static final ConfigDef config = KafkaProtobufSerializerConfig.baseConfigDef().define("reference.lookup.only", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, "Regardless of whether auto.register.schemas or use.latest.version is true, only look up the ID for references by using the schema.").define("skip.known.types", ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, "Whether to skip known types when resolving schema dependencies.").define("reference.subject.name.strategy", ConfigDef.Type.CLASS, DefaultReferenceSubjectNameStrategy.class, ConfigDef.Importance.LOW, "Determines how to construct the subject name for referenced schemas. By default, the reference name is used as subject.");

    public KafkaProtobufSerializerConfig(Map<?, ?> props) {
        super(config, props);
    }

    public boolean onlyLookupReferencesBySchema() {
        return this.getBoolean(REFERENCE_LOOKUP_ONLY_CONFIG);
    }

    public boolean skipKnownTypes() {
        return this.getBoolean(SKIP_KNOWN_TYPES_CONFIG);
    }

    public ReferenceSubjectNameStrategy referenceSubjectNameStrategyInstance() {
        return this.getConfiguredInstance(REFERENCE_SUBJECT_NAME_STRATEGY_CONFIG, ReferenceSubjectNameStrategy.class);
    }
}

