/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import org.apache.avro.SchemaCompatibility;

public class Difference {
    private final SchemaCompatibility.Incompatibility incompatibility;

    public Difference(SchemaCompatibility.Incompatibility incompatibility) {
        this.incompatibility = incompatibility;
    }

    public String error() {
        String errorDescription;
        SchemaCompatibility.SchemaIncompatibilityType errorType = this.incompatibility.getType();
        String path = this.incompatibility.getLocation();
        switch (errorType) {
            case FIXED_SIZE_MISMATCH: {
                errorDescription = "The size of FIXED type field at path '" + path + "' in the %s schema does not match with the %s schema";
                break;
            }
            case TYPE_MISMATCH: {
                errorDescription = "The type (path '" + path + "') of a field in the %s schema does not match with the %s schema";
                break;
            }
            case NAME_MISMATCH: {
                errorDescription = "The name of the schema has changed (path '" + path + "')";
                break;
            }
            case MISSING_ENUM_SYMBOLS: {
                errorDescription = "The %s schema is missing enum symbols '" + this.incompatibility.getMessage() + "' at path '" + path + "' in the %s schema";
                break;
            }
            case MISSING_UNION_BRANCH: {
                errorDescription = "The %s schema is missing a type inside a union field at path '" + path + "' in the %s schema";
                break;
            }
            case READER_FIELD_MISSING_DEFAULT_VALUE: {
                errorDescription = "The field '" + this.incompatibility.getMessage() + "' at path '" + path + "' in the %s schema has no default value and is missing in the %s schema";
                break;
            }
            default: {
                errorDescription = "";
            }
        }
        return "{errorType:'" + (Object)((Object)errorType) + '\'' + ", description:'" + errorDescription + '\'' + ", additionalInfo:'" + this.incompatibility.getMessage() + "'}";
    }

    public String toString() {
        return this.error();
    }
}

