/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j;

import com.github.caldav4j.ResourceMetadata;
import com.github.caldav4j.model.response.CalendarDataProperty;
import java.io.Serializable;
import net.fortuna.ical4j.model.Calendar;
import org.apache.jackrabbit.webdav.MultiStatusResponse;

public class CalDAVResource
implements Serializable {
    private static final long serialVersionUID = -2607152240683030192L;
    private ResourceMetadata resourceMetadata = null;
    private Calendar calendar = null;

    public CalDAVResource(MultiStatusResponse response) {
        this.calendar = CalendarDataProperty.getCalendarfromResponse(response);
        this.resourceMetadata = new ResourceMetadata();
        this.resourceMetadata.setETag(CalendarDataProperty.getEtagfromResponse(response));
        this.resourceMetadata.setHref(response.getHref());
    }

    public CalDAVResource(Calendar calendar, String etag, String href) {
        this.calendar = calendar;
        ResourceMetadata rm = new ResourceMetadata();
        rm.setETag(etag);
        rm.setHref(href);
        this.resourceMetadata = rm;
    }

    public CalDAVResource() {
        this.resourceMetadata = new ResourceMetadata();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }
}

