/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.core.utils;

import java.util.List;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycleUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestCycleUtils.class);

    private RequestCycleUtils() {
    }

    public static AjaxRequestTarget getAjaxRequestTarget() {
        return RequestCycle.get().find(AjaxRequestTarget.class).orElse(null);
    }

    public static IPartialPageRequestHandler getRequestHandler() {
        return RequestCycle.get().find(IPartialPageRequestHandler.class).orElse(null);
    }

    public static CharSequence getAjaxIndicatorUrl() {
        return RequestCycle.get().urlFor((IRequestHandler)new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR));
    }

    public static Class<? extends IRequestablePage> getPageClass() {
        IPageClassRequestHandler handler = RequestCycle.get().find(IPageClassRequestHandler.class).orElse(null);
        if (handler != null) {
            return handler.getPageClass();
        }
        return null;
    }

    public static boolean hasQueryParameter(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterNames().stream().anyMatch(name::equals);
    }

    public static StringValue getQueryParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getQueryParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValues(name);
    }

    public static StringValue getPostParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getPostParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getPostParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getPostParameters();
        return parameters.getParameterValues(name);
    }

    public static StringValue getRequestParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getRequestParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getRequestParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getRequestParameters();
        return parameters.getParameterValues(name);
    }

    public static void log(IRequestParameters parameters) {
        log.info("--IRequestParameters--");
        for (String name : parameters.getParameterNames()) {
            log.info("{}: {}", (Object)name, (Object)parameters.getParameterValue(name));
        }
    }
}

