/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.whoAmI;

import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.model.message.AbstractExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class WhoAmIResponseImpl
extends AbstractExtendedResponse
implements WhoAmIResponse {
    private byte[] authzId;
    private Dn dn;
    private String userId;

    public WhoAmIResponseImpl(int messageId, ResultCodeEnum rcode, String diagnosticMessage) {
        super(messageId, (String)null);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
        super.getLdapResult().setDiagnosticMessage(diagnosticMessage);
    }

    public WhoAmIResponseImpl(int messageId, ResultCodeEnum rcode) {
        super(messageId, "1.3.6.1.4.1.4203.1.11.3");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public WhoAmIResponseImpl(int messageId) {
        super(messageId, (String)null);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public WhoAmIResponseImpl() {
        super("1.3.6.1.4.1.4203.1.11.3");
        this.ldapResult.setMatchedDn(null);
        this.ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
    }

    @Override
    public byte[] getAuthzId() {
        return this.authzId;
    }

    public void setAuthzId(byte[] authzId) {
        this.authzId = authzId;
    }

    @Override
    public boolean isDnAuthzId() {
        return this.dn != null;
    }

    @Override
    public boolean isUserAuthzId() {
        return this.userId != null;
    }

    @Override
    public String getAuthzIdString() {
        return Strings.utf8ToString(this.authzId);
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    public void setDn(Dn dn) {
        this.dn = dn;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WhoAmI Extended Response :");
        sb.append("\n    authzid : ");
        if (this.authzId != null) {
            if (this.isDnAuthzId()) {
                sb.append("DN: ").append(this.getDn());
            } else {
                sb.append("UserId: ").append(this.getUserId());
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

