/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.core.util.References;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5PlayerCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5PlayerJavaScriptReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.html5player.Html5VideoConfig;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;

public class Html5Player
extends Panel {
    private static final long serialVersionUID = 1L;
    private final IModel<List<IVideo>> resources;
    private final Html5VideoConfig config;
    private final WebMarkupContainer container;
    private final IModel<String> errorMessage;
    private int width;
    private int height;

    public Html5Player(String markupId, IModel<List<IVideo>> model) {
        this(markupId, model, new Html5VideoConfig());
    }

    public Html5Player(String markupId, IModel<List<IVideo>> model, Html5VideoConfig config) {
        super(markupId, model);
        this.resources = model;
        this.config = config;
        this.width = 370;
        this.height = 215;
        this.errorMessage = Model.of((Serializable)((Object)"Your browser does not support the video tag."));
        Component[] componentArray = new Component[1];
        this.container = this.newVideoTag("video");
        componentArray[0] = this.container;
        this.add(componentArray);
        this.container.add(new Component[]{this.newVideoList("videos")});
        this.container.add(new Component[]{new Label("message", this.errorMessage).setRenderBodyOnly(true)});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, (ComponentTag)tag, (String[])new String[]{"div", "span"});
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"videoUiWrapper", "img-thumbnail"});
    }

    public Html5Player setWidth(int width) {
        this.width = width;
        return this;
    }

    public Html5Player setHeight(int height) {
        this.height = height;
        return this;
    }

    public Html5Player setErrorMessage(String message) {
        this.errorMessage.setObject((Object)message);
        return this;
    }

    private Component newVideoList(String markupId) {
        return new ListView<IVideo>(markupId, this.resources){
            private static final long serialVersionUID = 1L;

            protected void onInitialize() {
                super.onInitialize();
                this.setRenderBodyOnly(true);
            }

            protected void populateItem(ListItem<IVideo> item) {
                IVideo video = (IVideo)item.getModelObject();
                item.add(new Component[]{new WebMarkupContainer("element").add(new Behavior[]{new AttributeModifier("src", (Serializable)((Object)video.getUrl()))}).add(new Behavior[]{new AttributeModifier("type", (Serializable)((Object)video.getMediaType()))})});
            }
        };
    }

    private WebMarkupContainer newVideoTag(String markupId) {
        return new WebMarkupContainer(markupId){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("width", Html5Player.this.width);
                tag.put("height", Html5Player.this.height);
            }
        };
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)Html5PlayerCssReference.instance()));
        References.renderWithFilter((IBootstrapSettings)Bootstrap.getSettings(), (IHeaderResponse)response, (JavaScriptReferenceHeaderItem[])new JavaScriptReferenceHeaderItem[]{JavaScriptHeaderItem.forReference((ResourceReference)Html5PlayerJavaScriptReference.instance())});
        response.render((HeaderItem)JQuery.$((Component)this.container).chain((CharSequence)"videoUI", (Config)this.config, new Config[0]).asDomReadyScript());
    }

    public static interface IVideo
    extends IClusterable {
        public String getUrl();

        public String getMediaType();
    }
}

