/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.netpreserve.jwarc.HeaderValidator;
import org.netpreserve.jwarc.HttpMessage;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcTargetRecord;
import org.netpreserve.jwarc.tools.WarcTool;

public class ValidateTool
extends WarcTool {
    private static final MediaType DNS = MediaType.parse("text/dns");
    private Logger logger;
    private boolean verbose;
    private HeaderValidator headerValidator;

    public ValidateTool(boolean verbose) {
        this.verbose = verbose;
        this.logger = verbose ? new Logger() : new NonVerboseLogger();
    }

    private static long readBody(MessageBody body, Consumer<ByteBuffer> consumer) throws IOException {
        long size = 0L;
        int i = 0;
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while ((i = body.read(buffer)) > -1) {
            size += (long)i;
            buffer.flip();
            consumer.accept(buffer);
            buffer.compact();
        }
        return size;
    }

    private static void validateDigest(WarcDigest digestExpected, WarcDigest digestCalculated, long size) throws DigestException {
        if (!digestExpected.equals(digestCalculated)) {
            throw new DigestException("Failed to validate digest: expected " + digestExpected + ", got " + digestCalculated + " (on " + size + " bytes)");
        }
    }

    private static void validateDigest(MessageBody body, WarcDigest digest, AtomicLong consumedBytes) throws IOException, NoSuchAlgorithmException, DigestException {
        MessageDigest md = digest.getDigester();
        long size = ValidateTool.readBody(body, b -> md.update((ByteBuffer)b));
        consumedBytes.set(size);
        WarcDigest dig = new WarcDigest(md);
        ValidateTool.validateDigest(digest, dig, size);
    }

    private boolean validateCapture(WarcRecord record) throws IOException {
        HttpMessage http;
        boolean valid = true;
        int contentLength = -1;
        String targetUri = ((WarcTargetRecord)record).target();
        this.logger.log(targetUri);
        if (record instanceof WarcResponse && record.contentType().equals(MediaType.HTTP_RESPONSE)) {
            http = ((WarcResponse)record).http();
            this.logger.log("%s %d %s", http.version(), ((HttpResponse)http).status(), ((HttpResponse)http).reason());
            Optional<String> contentLengthHeader = http.headers().first("content-length");
            if (contentLengthHeader.isPresent()) {
                try {
                    contentLength = Integer.parseInt(contentLengthHeader.get());
                }
                catch (NumberFormatException e) {
                    this.logger.error("failed to read HTTP Content-Length header: %s", contentLengthHeader.get());
                    valid = false;
                }
            }
        } else if (record instanceof WarcRequest && record.contentType().equals(MediaType.HTTP_REQUEST)) {
            http = ((WarcRequest)record).http();
            this.logger.log("%s %s", http.version(), ((HttpRequest)http).method());
        } else if (!(record instanceof WarcResponse) || record.contentType().equals(DNS)) {
            // empty if block
        }
        this.logger.log("date: %s", record.date());
        Optional<WarcPayload> payload = ((WarcCaptureRecord)record).payload();
        if (payload.isPresent()) {
            MediaType type;
            try {
                type = payload.get().type().base();
                this.logger.log("payload media type: %s", type);
            }
            catch (IllegalArgumentException e) {
                this.logger.exception("Parsing Content-Type failed", e);
                type = MediaType.OCTET_STREAM;
            }
            Optional<WarcDigest> pdigest = payload.get().digest();
            long length = -1L;
            if (pdigest.isPresent()) {
                AtomicLong plength = new AtomicLong(length);
                try {
                    ValidateTool.validateDigest(payload.get().body(), pdigest.get(), plength);
                    this.logger.log("payload digest pass");
                }
                catch (DigestException e) {
                    this.logger.error("payload digest failed: %s", e.getMessage());
                    valid = false;
                }
                catch (NoSuchAlgorithmException e) {
                    this.logger.log("payload digest unknown algorithm: %s", e.getMessage());
                }
                length = plength.get();
            } else {
                length = ValidateTool.readBody(payload.get().body(), b -> b.position(b.limit()));
            }
            if (contentLength > 0 && (long)contentLength != length) {
                this.logger.error("invalid HTTP header Content-Length: %d", contentLength);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validate(WarcReader reader) throws IOException {
        boolean warcValidates = true;
        AtomicBoolean sawWarning = new AtomicBoolean(false);
        reader.onWarning(message -> {
            this.logger.error((String)message, new Object[0]);
            sawWarning.set(true);
        });
        WarcRecord record = reader.next().orElse(null);
        while (record != null) {
            boolean valid = true;
            if (this.headerValidator != null) {
                List<String> headerViolations = this.headerValidator.validate(record.headers());
                headerViolations.forEach(x$0 -> this.logger.error((String)x$0, new Object[0]));
                valid &= headerViolations.isEmpty();
            }
            if (record instanceof WarcCaptureRecord) {
                try {
                    valid = this.validateCapture(record);
                }
                catch (IOException e) {
                    this.logger.exception("Exception during validation", e);
                    valid = false;
                }
            } else {
                record.body().consume();
            }
            if (record.blockDigest().isPresent()) {
                Optional<WarcDigest> calculated = record.calculatedBlockDigest();
                if (calculated.isPresent()) {
                    try {
                        ValidateTool.validateDigest(record.blockDigest().get(), calculated.get(), record.body().position());
                        this.logger.log("block digest pass");
                    }
                    catch (DigestException e) {
                        this.logger.error("block digest failed: %s", e.getMessage());
                        valid = false;
                    }
                } else {
                    try {
                        record.blockDigest().get().getDigester();
                        this.logger.log("block digest not calculated (unknown reason)");
                    }
                    catch (NoSuchAlgorithmException e) {
                        this.logger.log("block digest not calculated: %s", e.getMessage());
                    }
                }
            }
            String recordType = record.type();
            MediaType contentType = record.contentType();
            long position = reader.position();
            if (sawWarning.getAndSet(false)) {
                valid = false;
            }
            record = reader.next().orElse(null);
            long length = reader.position() - position;
            if (this.verbose) {
                System.out.printf(this.logger.getPrefix() + "  offset %d (length %d) %s %s\n%s", position, length, recordType, contentType, this.logger.print());
            } else if (!valid) {
                System.err.printf(this.logger.getPrefix() + "  offset %d (length %d) %s %s failed\n", position, length, recordType, contentType);
            }
            if (valid) continue;
            warcValidates = false;
        }
        if (sawWarning.get()) {
            warcValidates = false;
        }
        return warcValidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validate(Path warcFile) {
        this.logger.setCurrentFilename(warcFile.getFileName().toString());
        try {
            WarcReader reader;
            block13: {
                boolean bl;
                reader = new WarcReader(warcFile);
                try {
                    reader.calculateBlockDigest();
                    if (this.verbose) {
                        System.out.println("Validating " + warcFile);
                    }
                    if (this.validate(reader)) break block13;
                    System.err.println("Failed to validate " + warcFile);
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        System.err.println("Exception validating " + warcFile + ": " + e);
                        e.printStackTrace();
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                reader.close();
                return bl;
            }
            boolean bl = true;
            reader.close();
            return bl;
        }
        finally {
            this.logger.clearCurrentFilename();
        }
    }

    private static void usage(int exitValue) {
        System.err.println("");
        System.err.println("ValidateTool [-h] [-v] filename...");
        System.err.println("");
        System.err.println("Options:");
        System.err.println("");
        System.err.println(" --no-header-validation\tskips checking headers against WARC standard rules");
        System.err.println(" --forbid-extensions\tdisallows non-standard WARC header fields and values");
        System.err.println(" -j / --threads\tmaximum number of threads to use (default: " + Runtime.getRuntime().availableProcessors() + ")");
        System.err.println(" -h / --help\tshow usage message and exit");
        System.err.println(" -v / --verbose\tlog information about every WARC record to stdout");
        System.err.println("");
        System.err.println("Exit value is 0 if all WARC/ARC files validate, 1 otherwise.");
        System.err.println("Errors and erroneous WARC/ARC records are logged to stderr.");
        System.err.println("");
        System.exit(exitValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int res = 0;
        boolean verbose = false;
        boolean headerValidation = true;
        boolean forbidExtensions = false;
        int threads = Runtime.getRuntime().availableProcessors();
        ArrayList<Path> warcFiles = new ArrayList<Path>();
        if (args.length == 0) {
            ValidateTool.usage(0);
        }
        block20: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--no-header-validation": {
                    headerValidation = false;
                    continue block20;
                }
                case "--forbid-extensions": {
                    forbidExtensions = true;
                    continue block20;
                }
                case "-h": 
                case "--help": {
                    ValidateTool.usage(0);
                    continue block20;
                }
                case "-j": 
                case "--threads": {
                    threads = Integer.parseInt(args[++i]);
                    continue block20;
                }
                case "-v": 
                case "--verbose": {
                    verbose = true;
                    continue block20;
                }
                default: {
                    warcFiles.add(Paths.get(args[i], new String[0]));
                }
            }
        }
        ValidateTool validator = new ValidateTool(verbose);
        if (headerValidation) {
            validator.headerValidator = HeaderValidator.warc_1_1(forbidExtensions);
        }
        ForkJoinPool pool = new ForkJoinPool(threads);
        try {
            res = (Integer)((ForkJoinTask)pool.submit(() -> warcFiles.parallelStream().map(validator::validate).anyMatch(valid -> valid == false) ? 1 : 0)).get();
        }
        finally {
            pool.shutdown();
        }
        System.exit(res);
    }

    private static class Logger {
        protected Optional<StringBuilder> sb = Optional.of(new StringBuilder());
        private static final ThreadLocal<String> currentFilename = new ThreadLocal();

        public void setCurrentFilename(String filename) {
            currentFilename.set(filename);
        }

        public void clearCurrentFilename() {
            currentFilename.remove();
        }

        private String getPrefix() {
            String filename = currentFilename.get();
            return filename != null ? filename + ": " : "";
        }

        public void log(String form) {
            this.sb.ifPresent(s -> s.append("    ").append(form).append('\n'));
        }

        public void log(String form, Object ... args) {
            this.sb.ifPresent(s -> s.append("    ").append(String.format(form, args)).append('\n'));
        }

        public void error(String form, Object ... args) {
            if (this.sb.isPresent()) {
                this.log("ERROR: " + form, args);
            } else {
                System.err.println(this.getPrefix() + "ERROR: " + String.format(form, args));
            }
        }

        public void exception(String message, Exception e) {
            if (this.sb.isPresent()) {
                this.log("ERROR: %s: %s", message, e);
            } else {
                System.err.println(this.getPrefix() + "ERROR: " + message + ": " + e);
            }
        }

        public String print() {
            String res = "";
            if (this.sb.isPresent()) {
                res = this.sb.get().toString();
                this.sb.get().setLength(0);
            }
            return res;
        }
    }

    private static class NonVerboseLogger
    extends Logger {
        public NonVerboseLogger() {
            this.sb = Optional.empty();
        }
    }
}

