/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BaseBlock;

public class CommentHeader
extends BaseBlock {
    public static final short commentHeaderSize = 6;
    private final short unpSize;
    private byte unpVersion;
    private byte unpMethod;
    private final short commCRC;

    public CommentHeader(BaseBlock bb, byte[] commentHeader) {
        super(bb);
        int pos = 0;
        this.unpSize = Raw.readShortLittleEndian(commentHeader, pos);
        this.unpVersion = (byte)(this.unpVersion | commentHeader[pos += 2] & 0xFF);
        this.unpMethod = (byte)(this.unpMethod | commentHeader[++pos] & 0xFF);
        this.commCRC = Raw.readShortLittleEndian(commentHeader, ++pos);
    }

    public short getCommCRC() {
        return this.commCRC;
    }

    public byte getUnpMethod() {
        return this.unpMethod;
    }

    public short getUnpSize() {
        return this.unpSize;
    }

    public byte getUnpVersion() {
        return this.unpVersion;
    }
}

