/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayStatistics;

public class ReplayStatisticsImpl
implements oracle.jdbc.replay.internal.ReplayStatistics,
Cloneable,
Serializable {
    private long totalRequests = 0L;
    private long totalCompletedRequests = 0L;
    private long totalCalls = 0L;
    private long totalProtectedCalls = 0L;
    private long totalCallsAffectedByOutages = 0L;
    private long totalCallsTriggeringReplay = 0L;
    private long totalCallsAffectedByOutagesDuringReplay = 0L;
    private long successfulReplayCount = 0L;
    private long failedReplayCount = 0L;
    private long replayDisablingCount = 0L;
    private long totalReplayAttempts = 0L;
    private int currentRequestSize = 0;
    private static final int HISTOGRAM_SIZE = 31;
    private int[] requestSizeHistogram = new int[31];

    public ReplayStatisticsImpl() {
    }

    public ReplayStatisticsImpl(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, int n2) {
        this.totalRequests = l2;
        this.totalCompletedRequests = l3;
        this.totalCalls = l4;
        this.totalProtectedCalls = l5;
        this.totalCallsAffectedByOutages = l6;
        this.totalCallsTriggeringReplay = l7;
        this.totalCallsAffectedByOutagesDuringReplay = l8;
        this.successfulReplayCount = l9;
        this.failedReplayCount = l10;
        this.replayDisablingCount = l11;
        this.totalReplayAttempts = l12;
        this.currentRequestSize = n2;
    }

    @Override
    public long getTotalRequests() {
        return this.totalRequests;
    }

    @Override
    public long getTotalCompletedRequests() {
        return this.totalCompletedRequests;
    }

    @Override
    public long getTotalCalls() {
        return this.totalCalls;
    }

    @Override
    public long getTotalProtectedCalls() {
        return this.totalProtectedCalls;
    }

    @Override
    public long getTotalCallsAffectedByOutages() {
        return this.totalCallsAffectedByOutages;
    }

    @Override
    public long getTotalCallsTriggeringReplay() {
        return this.totalCallsTriggeringReplay;
    }

    @Override
    public long getTotalCallsAffectedByOutagesDuringReplay() {
        return this.totalCallsAffectedByOutagesDuringReplay;
    }

    @Override
    public long getSuccessfulReplayCount() {
        return this.successfulReplayCount;
    }

    @Override
    public long getFailedReplayCount() {
        return this.failedReplayCount;
    }

    @Override
    public long getReplayDisablingCount() {
        return this.replayDisablingCount;
    }

    @Override
    public long getTotalReplayAttempts() {
        return this.totalReplayAttempts;
    }

    @Override
    public int getCurrentRequestSize() {
        return this.currentRequestSize;
    }

    @Override
    public int[] getRequestSizeHistogram() {
        int[] nArray = null;
        if (this.requestSizeHistogram != null && this.requestSizeHistogram.length > 0) {
            nArray = new int[this.requestSizeHistogram.length];
            System.arraycopy(this.requestSizeHistogram, 0, nArray, 0, this.requestSizeHistogram.length);
        }
        return nArray;
    }

    void incrementTotalRequests() {
        ++this.totalRequests;
    }

    void incrementTotalCompletedRequests() {
        ++this.totalCompletedRequests;
    }

    void incrementTotalCalls() {
        ++this.totalCalls;
    }

    void incrementTotalProtectedCalls() {
        ++this.totalProtectedCalls;
    }

    void incrementTotalCallsAffectedByOutages() {
        ++this.totalCallsAffectedByOutages;
    }

    void incrementTotalCallsTriggeringReplay() {
        ++this.totalCallsTriggeringReplay;
    }

    void incrementTotalCallsAffectedByOutagesDuringReplay() {
        ++this.totalCallsAffectedByOutagesDuringReplay;
    }

    void incrementSuccessfulReplayCount() {
        ++this.successfulReplayCount;
    }

    void incrementFailedReplayCount() {
        ++this.failedReplayCount;
    }

    void incrementReplayDisablingCount() {
        ++this.replayDisablingCount;
    }

    void incrementTotalReplayAttempts() {
        ++this.totalReplayAttempts;
    }

    void incrementCurrentRequestSize() {
        ++this.currentRequestSize;
    }

    public void aggregate(ReplayStatistics replayStatistics) {
        this.totalRequests += replayStatistics.getTotalRequests();
        this.totalCompletedRequests += replayStatistics.getTotalCompletedRequests();
        this.totalCalls += replayStatistics.getTotalCalls();
        this.totalProtectedCalls += replayStatistics.getTotalProtectedCalls();
        this.totalCallsAffectedByOutages += replayStatistics.getTotalCallsAffectedByOutages();
        this.totalCallsTriggeringReplay += replayStatistics.getTotalCallsTriggeringReplay();
        this.totalCallsAffectedByOutagesDuringReplay += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
        this.successfulReplayCount += replayStatistics.getSuccessfulReplayCount();
        this.failedReplayCount += replayStatistics.getFailedReplayCount();
        this.replayDisablingCount += replayStatistics.getReplayDisablingCount();
        this.totalReplayAttempts += replayStatistics.getTotalReplayAttempts();
        this.currentRequestSize += replayStatistics.getCurrentRequestSize();
    }

    void clearCurrentRequestSize() {
        this.currentRequestSize = 0;
    }

    void updateRequestSizeHistogram(int n2) {
        if (n2 > 0) {
            int n3 = -1;
            for (int i2 = n2; i2 > 0; i2 /= 2) {
                ++n3;
            }
            int n4 = n3;
            this.requestSizeHistogram[n4] = this.requestSizeHistogram[n4] + 1;
        }
    }

    @Override
    public void setRequestSizeHistogram(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            this.requestSizeHistogram = nArray;
        }
    }

    @Override
    public void clear() {
        this.totalRequests = 0L;
        this.totalCompletedRequests = 0L;
        this.totalCalls = 0L;
        this.totalProtectedCalls = 0L;
        this.totalCallsAffectedByOutages = 0L;
        this.totalCallsTriggeringReplay = 0L;
        this.totalCallsAffectedByOutagesDuringReplay = 0L;
        this.successfulReplayCount = 0L;
        this.failedReplayCount = 0L;
        this.replayDisablingCount = 0L;
        this.totalReplayAttempts = 0L;
        this.requestSizeHistogram = null;
    }

    @DisableTrace
    public String toString() {
        return "AC Statistics:" + "\n===============================================" + "\nTotalRequests = " + this.getTotalRequests() + "\nTotalCompletedRequests = " + this.getTotalCompletedRequests() + "\nTotalCalls = " + this.getTotalCalls() + "\nTotalProtectedCalls = " + this.getTotalProtectedCalls() + "\nCurrentRequestSize = " + this.getCurrentRequestSize() + "\n===============================================" + "\nTotalCallsAffectedByOutages = " + this.getTotalCallsAffectedByOutages() + "\nTotalCallsTriggeringReplay = " + this.getTotalCallsTriggeringReplay() + "\nTotalCallsAffectedByOutagesDuringReplay = " + this.getTotalCallsAffectedByOutagesDuringReplay() + "\n===============================================" + "\nSuccessfulReplayCount = " + this.getSuccessfulReplayCount() + "\nFailedReplayCount = " + this.getFailedReplayCount() + "\nReplayDisablingCount = " + this.getReplayDisablingCount() + "\nTotalReplayAttempts = " + this.getTotalReplayAttempts() + "\n===============================================";
    }

    @DisableTrace
    public String getRequestSizeHistogramString() {
        StringBuilder stringBuilder = new StringBuilder().append("AC Request-Size Histogram:").append("\n===============================================");
        if (this.requestSizeHistogram != null && this.requestSizeHistogram.length > 0) {
            int n2 = 1;
            int n3 = 0;
            for (int i2 = 0; i2 < this.requestSizeHistogram.length; ++i2) {
                if (n3 > 0) {
                    n2 = n3 + 1;
                }
                n3 = n2 * 2 - 1;
                stringBuilder.append("\nSizes between ").append(n2).append(" and ").append(n3).append(" : ").append(this.requestSizeHistogram[i2]);
            }
        }
        stringBuilder.append("\n===============================================");
        return stringBuilder.toString();
    }
}

