/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.office.LocalOfficeProcessManager;
import org.jodconverter.local.office.OfficeConnectionEvent;
import org.jodconverter.local.office.OfficeConnectionEventListener;
import org.jodconverter.local.task.PasswordProtectedExceptionSupportTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalOfficeManagerPoolEntry
extends AbstractOfficeManagerPoolEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOfficeManagerPoolEntry.class);
    private final int maxTasksPerProcess;
    private final LocalOfficeProcessManager officeProcessManager;
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private final AtomicBoolean disconnectExpected = new AtomicBoolean(false);
    private final AtomicReference<PasswordProtectedExceptionSupportTask> passwordProtectedExceptionSupportTask = new AtomicReference();

    LocalOfficeManagerPoolEntry(int maxTasksPerProcess, long taskExecutionTimeout, final LocalOfficeProcessManager officeProcessManager) {
        super(taskExecutionTimeout);
        this.officeProcessManager = officeProcessManager;
        this.maxTasksPerProcess = maxTasksPerProcess;
        OfficeConnectionEventListener connectionEventListener = new OfficeConnectionEventListener(){

            @Override
            public void connected(OfficeConnectionEvent event) {
                LocalOfficeManagerPoolEntry.this.taskCount.set(0);
                LocalOfficeManagerPoolEntry.this.setAvailable(true);
            }

            @Override
            public void disconnected(OfficeConnectionEvent event) {
                LocalOfficeManagerPoolEntry.this.setAvailable(false);
                if (!LocalOfficeManagerPoolEntry.this.disconnectExpected.compareAndSet(true, false)) {
                    PasswordProtectedExceptionSupportTask task = LocalOfficeManagerPoolEntry.this.passwordProtectedExceptionSupportTask.getAndSet(null);
                    if (task != null && task.hasPasswordInteractionRequest()) {
                        officeProcessManager.restart();
                    } else {
                        LOGGER.warn("Connection lost unexpectedly; attempting restart");
                        LocalOfficeManagerPoolEntry.this.cancelTask();
                        officeProcessManager.restartDueToLostConnection();
                    }
                }
            }
        };
        officeProcessManager.getConnection().addConnectionEventListener(connectionEventListener);
    }

    public void doExecute(@NonNull OfficeTask task) throws OfficeException {
        LOGGER.debug("Executing task: {}", (Object)task);
        this.passwordProtectedExceptionSupportTask.set(null);
        if (task instanceof PasswordProtectedExceptionSupportTask) {
            this.passwordProtectedExceptionSupportTask.set((PasswordProtectedExceptionSupportTask)task);
        }
        task.execute((OfficeContext)this.officeProcessManager.getConnection());
        LOGGER.debug("Task executed successfully: {}", (Object)task);
        int count = this.taskCount.incrementAndGet();
        if (count == this.maxTasksPerProcess) {
            LOGGER.info("Reached limit of {} maximum tasks per process; restarting...", (Object)this.maxTasksPerProcess);
            this.restart();
        } else {
            LOGGER.debug("Limit of {} maximum tasks per process not reached yet. Task count is {}", (Object)this.maxTasksPerProcess, (Object)count);
        }
    }

    protected void handleExecuteTimeoutException(@NonNull TimeoutException timeoutEx) {
        this.officeProcessManager.restartDueToTaskTimeout();
    }

    public boolean isRunning() {
        return super.isRunning() && this.officeProcessManager.getConnection().isConnected();
    }

    public void doStart() throws OfficeException {
        this.officeProcessManager.start();
    }

    public void doStop() throws OfficeException {
        this.setAvailable(false);
        this.disconnectExpected.set(true);
        this.officeProcessManager.stop();
    }

    private void restart() {
        this.setAvailable(false);
        this.disconnectExpected.set(true);
        this.officeProcessManager.restart();
    }
}

