/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util.logging;

import io.prometheus.metrics.core.datapoints.GaugeDataPoint;
import io.prometheus.metrics.core.metrics.Gauge;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatStats {
    private static final Logger log = LoggerFactory.getLogger(TomcatStats.class);
    private static final String[] LBL_NAMES = new String[]{"name"};
    private static final Gauge rqBytesReceived = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_requestprocessor_received_bytes")).help("Number of bytes received by this request processor")).labelNames(LBL_NAMES)).register();
    private static final Gauge rqBytesSent = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_requestprocessor_sent_bytes")).help("Number of bytes sent by this request processor")).labelNames(LBL_NAMES)).register();
    private static final Gauge rqTime = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_requestprocessor_time_seconds")).help("The total time spend by this request processor")).labelNames(LBL_NAMES)).register();
    private static final Gauge rqErrors = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_requestprocessor_error_count")).help("The number of error request served by this request processor")).labelNames(LBL_NAMES)).register();
    private static final Gauge rqRequests = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_requestprocessor_request_count")).help("The number of request served by this request processor")).labelNames(LBL_NAMES)).register();
    private static final Gauge threads = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_threads")).help("Number threads in this pool.")).labelNames(LBL_NAMES)).register();
    private static final Gauge threadsActive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_threads_active")).help("Number of active threads in this pool.")).labelNames(LBL_NAMES)).register();
    private static final Gauge threadsMax = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_threads_max")).help("Maximum number of threads allowed in this pool.")).labelNames(LBL_NAMES)).register();
    private static final Gauge connsActive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_connections_active")).help("Number of connections served by this pool.")).labelNames(LBL_NAMES)).register();
    private static final Gauge connsActiveMax = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_connections_active_max")).help("Maximum number of concurrent connections served by this pool.")).labelNames(LBL_NAMES)).register();
    private static final String[] SESSION_LBL_NAMES = new String[]{"host", "context"};
    private static final Gauge sessionActive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_session_active")).help("Number of active sessions")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge sessionRejected = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_session_rejected")).help("Number of sessions rejected due to maxActive being reached")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge sessionCreated = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_session_constructed")).help("Number of sessions created")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge sessionExpired = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_session_expired")).help("Number of sessions that expired")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge sessionAvgAlive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_session_alivetime_seconds_avg")).help("Average time an expired session had been alive")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge sessionMaxAlive = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_session_alivetime_seconds_max")).help("Maximum time an expired session had been alive")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge ctxState = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_context_state_started")).help("Indication if the lifecycle state of this context is STARTED")).labelNames(SESSION_LBL_NAMES)).register();
    private static final Gauge version = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("tomcat_details")).help("tomcat version info")).labelNames(new String[]{"version", "build"})).register();
    private final String jmxDomain;

    public TomcatStats(boolean embedded) {
        this.jmxDomain = embedded ? "Tomcat" : "Catalina";
    }

    private double getAttr(Attribute attribute) {
        return ((Number)attribute.getValue()).doubleValue();
    }

    private double getAttr(MBeanServer server, ObjectInstance mBean, String attr) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        return ((Number)server.getAttribute(mBean.getObjectName(), attr)).doubleValue();
    }

    private void updateRequestProcessorMetrics() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName(this.jmxDomain + ":type=GlobalRequestProcessor,name=*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            for (ObjectInstance mBean : mBeans) {
                String labels = mBean.getObjectName().getKeyProperty("name").replaceAll("[\"\\\\]", "");
                ((GaugeDataPoint)rqBytesReceived.labelValues(new String[]{labels})).set(this.getAttr(server, mBean, "bytesReceived"));
                ((GaugeDataPoint)rqBytesSent.labelValues(new String[]{labels})).set(this.getAttr(server, mBean, "bytesSent"));
                ((GaugeDataPoint)rqTime.labelValues(new String[]{labels})).set(this.getAttr(server, mBean, "processingTime") / 1000.0);
                ((GaugeDataPoint)rqErrors.labelValues(new String[]{labels})).set(this.getAttr(server, mBean, "errorCount"));
                ((GaugeDataPoint)rqRequests.labelValues(new String[]{labels})).set(this.getAttr(server, mBean, "requestCount"));
            }
        }
        catch (Exception e) {
            log.error("Error retrieving RequestProcessor metric.", (Throwable)e);
        }
    }

    private void updateSessionMetrics() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName(this.jmxDomain + ":type=Manager,context=*,host=*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            for (ObjectInstance mBean : mBeans) {
                String[] labelValues = new String[]{mBean.getObjectName().getKeyProperty("host"), mBean.getObjectName().getKeyProperty("context")};
                ((GaugeDataPoint)sessionActive.labelValues(labelValues)).set(this.getAttr(server, mBean, "activeSessions"));
                ((GaugeDataPoint)sessionRejected.labelValues(labelValues)).set(this.getAttr(server, mBean, "rejectedSessions"));
                ((GaugeDataPoint)sessionCreated.labelValues(labelValues)).set(this.getAttr(server, mBean, "sessionCounter"));
                ((GaugeDataPoint)sessionExpired.labelValues(labelValues)).set(this.getAttr(server, mBean, "expiredSessions"));
                ((GaugeDataPoint)sessionAvgAlive.labelValues(labelValues)).set(this.getAttr(server, mBean, "sessionAverageAliveTime"));
                ((GaugeDataPoint)sessionMaxAlive.labelValues(labelValues)).set(this.getAttr(server, mBean, "sessionMaxAliveTime"));
                ((GaugeDataPoint)ctxState.labelValues(labelValues)).set("STARTED".equals(server.getAttribute(mBean.getObjectName(), "stateName")) ? 1.0 : 0.0);
            }
        }
        catch (Exception e) {
            log.error("Error retrieving Session metric.", (Throwable)e);
        }
    }

    private void updateThreadPoolMetrics() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName filterName = new ObjectName(this.jmxDomain + ":type=ThreadPool,name=*");
            Set<ObjectInstance> mBeans = server.queryMBeans(filterName, null);
            if (!mBeans.isEmpty()) {
                String[] genericAttributes = new String[]{"currentThreadCount", "currentThreadsBusy", "maxThreads", "connectionCount", "maxConnections"};
                for (ObjectInstance mBean : mBeans) {
                    String label = mBean.getObjectName().getKeyProperty("name").replaceAll("[\"\\\\]", "");
                    AttributeList attributeList = server.getAttributes(mBean.getObjectName(), genericAttributes);
                    block17: for (Attribute attribute : attributeList.asList()) {
                        switch (attribute.getName()) {
                            case "currentThreadCount": {
                                ((GaugeDataPoint)threads.labelValues(new String[]{label})).set(this.getAttr(attribute));
                                continue block17;
                            }
                            case "currentThreadsBusy": {
                                ((GaugeDataPoint)threadsActive.labelValues(new String[]{label})).set(this.getAttr(attribute));
                                continue block17;
                            }
                            case "maxThreads": {
                                ((GaugeDataPoint)threadsMax.labelValues(new String[]{label})).set(this.getAttr(attribute));
                                continue block17;
                            }
                            case "connectionCount": {
                                ((GaugeDataPoint)connsActive.labelValues(new String[]{label})).set(this.getAttr(attribute));
                                continue block17;
                            }
                            case "maxConnections": {
                                ((GaugeDataPoint)connsActiveMax.labelValues(new String[]{label})).set(this.getAttr(attribute));
                                continue block17;
                            }
                        }
                        log.warn("Unexpected attribute {}", (Object)attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Error retrieving ThreadPool metric: {}", (Object)e.getMessage());
        }
    }

    private void updateVersionInfo() {
        try (InputStream is = this.getClass().getResourceAsStream("/org/apache/catalina/util/ServerInfo.properties");){
            Properties props = new Properties();
            props.load(is);
            ((GaugeDataPoint)version.labelValues(new String[]{props.getProperty("server.number"), props.getProperty("server.built")})).set(1.0);
        }
        catch (Exception t) {
            log.warn("Unable to read Tomcat version: ", (Throwable)t);
        }
    }

    public void refresh() {
        this.updateRequestProcessorMetrics();
        this.updateSessionMetrics();
        this.updateThreadPoolMetrics();
        this.updateVersionInfo();
    }
}

