/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.calendar;

import com.github.openjson.JSONObject;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.webjars.request.resource.WebjarsJavaScriptResourceReference;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.service.calendar.caldav.AppointmentManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.UserBasePanel;
import org.apache.openmeetings.web.user.calendar.AppointmentDialog;
import org.apache.openmeetings.web.user.calendar.AppointmentModel;
import org.apache.openmeetings.web.user.calendar.CalendarDialog;
import org.apache.openmeetings.web.util.CalendarWebHelper;
import org.apache.openmeetings.web.util.TouchPunchResourceReference;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.calendar6.CalendarView;
import org.wicketstuff.jquery.ui.calendar6.DateTimeDelta;
import org.wicketstuff.jquery.ui.calendar6.EventSource;

public class CalendarPanel
extends UserBasePanel {
    private static final Logger log = LoggerFactory.getLogger(CalendarPanel.class);
    private static final long serialVersionUID = 1L;
    private static final ResourceReference CALJS = new JavaScriptResourceReference(CalendarPanel.class, "calendar-functions.js");
    private static final ResourceReference BS5_THEME = new WebjarsJavaScriptResourceReference("fullcalendar__bootstrap5/current/index.global.js");
    private final AbstractAjaxTimerBehavior refreshTimer = new AbstractAjaxTimerBehavior(Duration.ofSeconds(10L)){
        private static final long serialVersionUID = 1L;

        protected void onTimer(AjaxRequestTarget target) {
            CalendarPanel.this.refresh((IPartialPageRequestHandler)target);
        }
    };
    private AbstractAjaxTimerBehavior syncTimer = new AbstractAjaxTimerBehavior(Duration.ofMinutes(4L)){
        private static final long serialVersionUID = 1L;

        protected void onTimer(AjaxRequestTarget target) {
            log.debug("CalDAV Syncing has begun");
            CalendarPanel.this.syncCalendar(target);
        }
    };
    private org.wicketstuff.jquery.ui.calendar6.Calendar calendar;
    private CalendarDialog calendarDialog;
    private AppointmentDialog dialog;
    private final WebMarkupContainer calendarListContainer = new WebMarkupContainer("calendarListContainer");
    private transient HttpClient client = null;
    private transient HttpClientContext context = null;
    @Inject
    private AppointmentDao apptDao;
    @Inject
    private AppointmentManager apptManager;
    @Inject
    private UserDao userDao;

    public CalendarPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.dialog = new AppointmentDialog("calendarAppointment", this, (CompoundPropertyModel<Appointment>)new CompoundPropertyModel((Object)this.getDefault()));
        this.add(new Component[]{this.dialog});
        boolean isRtl = this.isRtl();
        Options options = new Options().set("direction", (Object)Options.asString((String)(isRtl ? "rtl" : "ltr"))).set("height", (Object)Options.asString((String)"100%")).set("customButtons", (Object)"{gotoBtn: {text: ' ', click: onOmGotoClick}}").set("headerToolbar", (Object)"{start: 'prevYear,prev,next,nextYear today,gotoBtn', center: 'title', end: 'dayGridMonth,timeGridWeek,timeGridDay'}").set("allDaySlot", (Object)false).set("nowIndicator", (Object)true).set("defaultTimedEventDuration", (Object)Options.asString((String)"01:00")).set("selectMirror", (Object)true).set("themeSystem", (Object)Options.asString((String)"bootstrap5")).set("buttonIcons", (Object)new JSONObject().put("close", (Object)"bi fa-solid fa-times").put("prev", (Object)(isRtl ? "bi fa-solid fa-chevron-right" : "bi fa-solid fa-chevron-left")).put("next", (Object)(isRtl ? "bi fa-solid fa-chevron-left" : "bi fa-solid fa-chevron-right")).put("prevYear", (Object)(isRtl ? "bi fa-solid fa-angles-right" : "bi fa-solid fa-angles-left")).put("nextYear", (Object)(isRtl ? "bi fa-solid fa-angles-left" : "bi fa-solid fa-angles-right")).toString()).set("buttonText", (Object)new JSONObject().put("month", (Object)this.getString("801")).put("week", (Object)this.getString("800")).put("day", (Object)this.getString("799")).put("today", (Object)this.getString("1555")).toString()).set("locale", (Object)Options.asString((String)WebSession.get().getLocale().toLanguageTag()));
        this.calendar = new org.wicketstuff.jquery.ui.calendar6.Calendar("calendar", new AppointmentModel(), options){
            private static final long serialVersionUID = 1L;

            public boolean isSelectable() {
                return true;
            }

            public boolean isDateClickEnabled() {
                return true;
            }

            public boolean isEventClickEnabled() {
                return true;
            }

            public boolean isEventDropEnabled() {
                return true;
            }

            public boolean isEventResizeEnabled() {
                return true;
            }

            public void onSelect(AjaxRequestTarget target, CalendarView view, LocalDateTime start, LocalDateTime end, boolean allDay) {
                Appointment a = CalendarPanel.this.getDefault();
                LocalDateTime s = start;
                LocalDateTime e = end;
                if (CalendarView.dayGridMonth == view) {
                    LocalDateTime now = ZonedDateTime.now(CalendarWebHelper.getZoneId()).toLocalDateTime();
                    s = start.withHour(now.getHour()).withMinute(now.getMinute());
                    e = s.plus(1L, ChronoUnit.HOURS);
                }
                a.setStart(CalendarWebHelper.getDate(s));
                a.setEnd(CalendarWebHelper.getDate(e));
                CalendarPanel.this.dialog.setModelObjectWithAjaxTarget(a, target);
                CalendarPanel.this.dialog.show((IPartialPageRequestHandler)target);
            }

            public void onEventClick(AjaxRequestTarget target, CalendarView view, String eventId) {
                if (!StringUtils.isNumeric((CharSequence)eventId)) {
                    return;
                }
                Appointment a = CalendarPanel.this.apptDao.get(Long.valueOf(eventId));
                CalendarPanel.this.dialog.setModelObjectWithAjaxTarget(a, target);
                CalendarPanel.this.dialog.show((IPartialPageRequestHandler)target);
            }

            public void onEventDrop(AjaxRequestTarget target, String eventId, DateTimeDelta delta, boolean allDay) {
                if (!StringUtils.isNumeric((CharSequence)eventId)) {
                    this.refresh((IPartialPageRequestHandler)target);
                    return;
                }
                Appointment a = CalendarPanel.this.apptDao.get(Long.valueOf(eventId));
                if (!AppointmentDialog.isOwner(a)) {
                    return;
                }
                Calendar cal = WebSession.getCalendar();
                cal.setTime(a.getStart());
                cal.add(1, delta.years());
                cal.add(2, delta.months());
                cal.add(5, delta.days());
                cal.add(14, delta.millis());
                a.setStart(cal.getTime());
                cal.setTime(a.getEnd());
                cal.add(1, delta.years());
                cal.add(2, delta.months());
                cal.add(5, delta.days());
                cal.add(14, delta.millis());
                a.setEnd(cal.getTime());
                CalendarPanel.this.apptDao.update(a, WebSession.getUserId());
                if (a.getCalendar() != null) {
                    CalendarPanel.this.updatedeleteAppointment((IPartialPageRequestHandler)target, CalendarDialog.DIALOG_TYPE.UPDATE_APPOINTMENT, a);
                }
            }

            public void onEventResize(AjaxRequestTarget target, String eventId, DateTimeDelta delta) {
                if (!StringUtils.isNumeric((CharSequence)eventId)) {
                    this.refresh((IPartialPageRequestHandler)target);
                    return;
                }
                Appointment a = CalendarPanel.this.apptDao.get(Long.valueOf(eventId));
                if (!AppointmentDialog.isOwner(a)) {
                    return;
                }
                Calendar cal = WebSession.getCalendar();
                cal.setTime(a.getEnd());
                cal.add(1, delta.years());
                cal.add(2, delta.months());
                cal.add(5, delta.days());
                cal.add(14, delta.millis());
                a.setEnd(cal.getTime());
                CalendarPanel.this.apptDao.update(a, WebSession.getUserId());
                if (a.getCalendar() != null) {
                    CalendarPanel.this.updatedeleteAppointment((IPartialPageRequestHandler)target, CalendarDialog.DIALOG_TYPE.UPDATE_APPOINTMENT, a);
                }
            }
        };
        form.add(new Component[]{this.calendar});
        this.populateGoogleCalendars();
        this.add(new Behavior[]{this.refreshTimer});
        this.add(new Behavior[]{this.syncTimer});
        this.calendarDialog = new CalendarDialog("calendarDialog", this, (CompoundPropertyModel<OmCalendar>)new CompoundPropertyModel((Object)this.getDefaultCalendar()));
        this.add(new Component[]{this.calendarDialog});
        this.calendarListContainer.setOutputMarkupId(true);
        this.calendarListContainer.add(new Component[]{new ListView<OmCalendar>("items", (IModel)new LoadableDetachableModel<List<OmCalendar>>(){
            private static final long serialVersionUID = 1L;

            protected List<OmCalendar> load() {
                ArrayList<OmCalendar> cals = new ArrayList<OmCalendar>(CalendarPanel.this.apptManager.getCalendars(WebSession.getUserId()));
                cals.addAll(CalendarPanel.this.apptManager.getGoogleCalendars(WebSession.getUserId()));
                return cals;
            }
        }){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<OmCalendar> item) {
                item.setOutputMarkupId(true);
                OmCalendar cal = (OmCalendar)item.getModelObject();
                item.add(new Component[]{new WebMarkupContainer("item").add(new Component[]{new Label("name", (Serializable)((Object)cal.getTitle()))})});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    CalendarPanel.this.calendarDialog.show((IPartialPageRequestHandler)target, CalendarDialog.DIALOG_TYPE.UPDATE_CALENDAR, cal);
                    target.add(new Component[]{CalendarPanel.this.calendarDialog});
                })});
            }
        }});
        this.add(new Component[]{new BootstrapAjaxLink<String>("syncCalendarButton", null, Buttons.Type.Outline_Primary, (IModel)new ResourceModel("calendar.sync")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                CalendarPanel.this.syncCalendar(target);
            }
        }.setSize(Buttons.Size.Small)});
        this.add(new Component[]{new BootstrapAjaxLink<String>("submitCalendar", null, Buttons.Type.Outline_Primary, (IModel)new ResourceModel("calendar.addCalendar")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                CalendarPanel.this.calendarDialog.show((IPartialPageRequestHandler)target, CalendarDialog.DIALOG_TYPE.UPDATE_CALENDAR, CalendarPanel.this.getDefaultCalendar());
                target.add(new Component[]{CalendarPanel.this.calendarDialog});
            }
        }.setSize(Buttons.Size.Small)});
        this.add(new Component[]{this.calendarListContainer});
        super.onInitialize();
    }

    @Override
    public void cleanup(IPartialPageRequestHandler handler) {
        this.refreshTimer.stop(handler);
        this.syncTimer.stop(handler);
        if (this.client != null) {
            this.apptManager.cleanupIdleConnections();
            if (this.context != null) {
                this.context.getCredentialsProvider().clear();
            }
        }
    }

    public void refresh(IPartialPageRequestHandler handler) {
        this.calendar.refresh(handler);
    }

    public void refreshCalendars(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this.dialog, this.calendarListContainer});
    }

    org.wicketstuff.jquery.ui.calendar6.Calendar getCalendar() {
        return this.calendar;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)CALJS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)TouchPunchResourceReference.instance()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BS5_THEME));
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)"FullCalendar.Bootstrap5.Internal.BootstrapTheme.prototype.rtlIconClasses = null", (String)"fullcalendar-bootstrap-reset-rtl"));
    }

    public HttpClient getHttpClient() {
        if (this.client == null) {
            this.client = this.apptManager.createHttpClient();
        }
        return this.client;
    }

    public HttpClientContext getHttpClientContext() {
        if (this.context == null) {
            this.context = HttpClientContext.create();
            this.context.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        }
        return this.context;
    }

    public void populateGoogleCalendar(OmCalendar gcal, IPartialPageRequestHandler target) {
        this.calendar.addSource((EventSource)new EventSource.GoogleCalendar(gcal.getHref(), gcal.getToken()));
        this.refresh(target);
    }

    private void populateGoogleCalendars() {
        List gcals = this.apptManager.getGoogleCalendars(WebSession.getUserId());
        for (OmCalendar gcal : gcals) {
            this.calendar.addSource((EventSource)new EventSource.GoogleCalendar(gcal.getHref(), gcal.getToken()));
        }
    }

    private OmCalendar getDefaultCalendar() {
        OmCalendar c = new OmCalendar();
        c.setDeleted(false);
        c.setOwner(this.userDao.get(WebSession.getUserId()));
        c.setTitle(this.getString("calendar.defaultTitle"));
        return c;
    }

    public void syncCalendar(AjaxRequestTarget target) {
        this.calendarDialog.show((IPartialPageRequestHandler)target, CalendarDialog.DIALOG_TYPE.SYNC_CALENDAR, (OmCalendar)null);
    }

    public void updatedeleteAppointment(IPartialPageRequestHandler target, CalendarDialog.DIALOG_TYPE type, Appointment a) {
        this.calendarDialog.show(target, type, a);
    }

    private Appointment getDefault() {
        Appointment a = new Appointment();
        a.setReminder(Appointment.Reminder.ICAL);
        a.setOwner(this.userDao.get(WebSession.getUserId()));
        a.setTitle(this.getString("1444"));
        log.debug(" -- getDefault -- Current model {}", (Object)a);
        return a;
    }
}

