/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import java.time.Duration;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;

public abstract class OmTimerBehavior
extends AbstractAjaxTimerBehavior {
    private static final long serialVersionUID = 1L;
    private final long clock = System.currentTimeMillis();
    private final int delay;
    private final String labelId;

    protected OmTimerBehavior(int delay, String labelId) {
        super(Duration.ofSeconds(1L));
        this.delay = delay;
        this.labelId = labelId;
    }

    protected static String getTime(int remain) {
        Duration d = Duration.ofSeconds(remain);
        return String.format("%d:%02d:%02d", d.toHours(), d.toMinutesPart(), d.toSecondsPart());
    }

    public static String getText(String text, int remain) {
        return text + ": " + OmTimerBehavior.getTime(remain);
    }

    protected String getText(int remain) {
        return OmTimerBehavior.getText(this.getComponent().getString(this.labelId), remain);
    }

    private int remain(long now) {
        return (int)((long)this.delay - (now - this.clock) / 1000L);
    }

    protected void onBind() {
        super.onBind();
        this.getComponent().setDefaultModelObject((Object)this.getText(this.delay));
        this.getComponent().setOutputMarkupId(true);
        this.onTimer(this.delay);
    }

    protected void onTimer(int remain) {
    }

    protected void onTimer(AjaxRequestTarget target) {
        int remain = this.remain(System.currentTimeMillis());
        if (remain > -1) {
            this.getComponent().setDefaultModelObject((Object)this.getText(remain));
            this.onTimer(remain);
            target.add(new Component[]{this.getComponent()});
        } else {
            this.stop((IPartialPageRequestHandler)target);
            this.onFinish(target);
        }
    }

    protected abstract void onFinish(AjaxRequestTarget var1);
}

