/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import org.springframework.aop.ClassFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RootClassFilter
implements ClassFilter,
Serializable {
    private final Class<?> clazz;

    public RootClassFilter(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        this.clazz = clazz;
    }

    @Override
    public boolean matches(Class<?> candidate) {
        return this.clazz.isAssignableFrom(candidate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof RootClassFilter)) return false;
        RootClassFilter that = (RootClassFilter)other;
        if (!this.clazz.equals(that.clazz)) return false;
        return true;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.clazz.getName();
    }
}

