/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.internal.monitor.LocalWanPublisherStats;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.wan.WanEvent;
import com.hazelcast.wan.WanMigrationAwarePublisher;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.impl.InternalWanEvent;
import com.hazelcast.wan.impl.InternalWanPublisher;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public final class DelegatingWanScheme {
    private final String name;
    private final ConcurrentMap<String, WanPublisher> publishers;

    public DelegatingWanScheme(@Nonnull String name, @Nonnull ConcurrentMap<String, WanPublisher> publishers) {
        Preconditions.checkNotNull(name, "WAN publisher name should not be null");
        Preconditions.checkNotNull(publishers, "WAN publisher map should not be null");
        this.name = name;
        this.publishers = publishers;
    }

    @Nonnull
    public Collection<WanPublisher> getPublishers() {
        return this.publishers.values();
    }

    public WanPublisher getPublisher(String publisherId) {
        return (WanPublisher)this.publishers.get(publisherId);
    }

    public void addPublisher(@Nonnull String publisherId, @Nonnull WanPublisher publisher) {
        if (this.publishers.putIfAbsent(publisherId, publisher) != null) {
            throw new IllegalStateException("Publisher with publisher ID " + publisherId + " on WAN replication scheme " + this.name + " is already present and cannot be overriden");
        }
    }

    public String getName() {
        return this.name;
    }

    public void publishReplicationEvent(WanEvent event) {
        for (WanPublisher publisher : this.publishers.values()) {
            publisher.publishReplicationEvent(event);
        }
    }

    public void publishReplicationEventBackup(WanEvent event) {
        for (WanPublisher publisher : this.publishers.values()) {
            publisher.publishReplicationEventBackup(event);
        }
    }

    public void republishReplicationEvent(InternalWanEvent wanEvent) {
        for (WanPublisher publisher : this.publishers.values()) {
            if (!(publisher instanceof InternalWanPublisher)) continue;
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            wanPublisher.republishReplicationEvent(wanEvent);
        }
    }

    public Map<String, LocalWanPublisherStats> getStats() {
        Map<String, LocalWanPublisherStats> statsMap = MapUtil.createHashMap(this.publishers.size());
        for (Map.Entry publisherEntry : this.publishers.entrySet()) {
            WanPublisher publisher = (WanPublisher)publisherEntry.getValue();
            if (!(publisher instanceof InternalWanPublisher)) continue;
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            String publisherId = (String)publisherEntry.getKey();
            LocalWanPublisherStats stats = wanPublisher.getStats();
            if (stats == null) continue;
            statsMap.put(publisherId, stats);
        }
        return statsMap;
    }

    public void doPrepublicationChecks() {
        for (WanPublisher publisher : this.publishers.values()) {
            publisher.doPrepublicationChecks();
        }
    }

    public Map<String, Object> prepareEventContainerReplicationData(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        Map<String, Object> eventContainers = MapUtil.createHashMap(this.publishers.size());
        for (Map.Entry publisherEntry : this.publishers.entrySet()) {
            WanMigrationAwarePublisher awarePublisher;
            Object eventContainer;
            WanPublisher publisher = (WanPublisher)publisherEntry.getValue();
            if (!(publisher instanceof WanMigrationAwarePublisher) || (eventContainer = (awarePublisher = (WanMigrationAwarePublisher)((Object)publisher)).prepareEventContainerReplicationData(event, namespaces)) == null) continue;
            String publisherId = (String)publisherEntry.getKey();
            eventContainers.put(publisherId, eventContainer);
        }
        return eventContainers;
    }

    public void collectAllServiceNamespaces(PartitionReplicationEvent event, Set<ServiceNamespace> namespaces) {
        for (WanPublisher publisher : this.publishers.values()) {
            if (!(publisher instanceof WanMigrationAwarePublisher)) continue;
            WanMigrationAwarePublisher awarePublisher = (WanMigrationAwarePublisher)((Object)publisher);
            awarePublisher.collectAllServiceNamespaces(event, namespaces);
        }
    }

    public void destroyMapData(String mapName) {
        for (WanPublisher publisher : this.publishers.values()) {
            if (!(publisher instanceof InternalWanPublisher)) continue;
            InternalWanPublisher wanPublisher = (InternalWanPublisher)publisher;
            wanPublisher.destroyMapData(mapName);
        }
    }
}

