/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.everit.json.schema;

import com.hazelcast.shaded.org.everit.json.schema.JSONPointer;
import com.hazelcast.shaded.org.everit.json.schema.Schema;
import com.hazelcast.shaded.org.everit.json.schema.SchemaException;
import com.hazelcast.shaded.org.everit.json.schema.Visitor;
import com.hazelcast.shaded.org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import com.hazelcast.shaded.org.everit.json.schema.regexp.Regexp;
import com.hazelcast.shaded.org.everit.json.schema.regexp.RegexpFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ObjectSchema
extends Schema {
    private final Map<String, Schema> propertySchemas;
    private final boolean additionalProperties;
    private final Schema schemaOfAdditionalProperties;
    private final Schema propertyNameSchema;
    private final List<String> requiredProperties;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Map<String, Set<String>> propertyDependencies;
    private final Map<String, Schema> schemaDependencies;
    private final boolean requiresObject;
    private final Map<Regexp, Schema> patternProperties;
    private final boolean oneOrMoreDefaultProperty;

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> original) {
        return Collections.unmodifiableMap(new HashMap<K, V>(original));
    }

    public ObjectSchema(Builder builder) {
        super(builder);
        this.propertySchemas = builder.propertySchemas == null ? null : Collections.unmodifiableMap(builder.propertySchemas);
        this.additionalProperties = builder.additionalProperties;
        this.schemaOfAdditionalProperties = builder.schemaOfAdditionalProperties;
        if (!this.additionalProperties && this.schemaOfAdditionalProperties != null) {
            throw new SchemaException("additionalProperties cannot be false if schemaOfAdditionalProperties is present");
        }
        this.requiredProperties = Collections.unmodifiableList(new ArrayList(builder.requiredProperties));
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.propertyDependencies = ObjectSchema.copyMap(builder.propertyDependencies);
        this.schemaDependencies = ObjectSchema.copyMap(builder.schemaDependencies);
        this.requiresObject = builder.requiresObject;
        this.patternProperties = ObjectSchema.copyMap(builder.patternProperties);
        this.propertyNameSchema = builder.propertyNameSchema;
        this.oneOrMoreDefaultProperty = builder.oneOrMoreDefaultProperty;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    Map<Regexp, Schema> getRegexpPatternProperties() {
        return this.patternProperties;
    }

    @Deprecated
    public Map<Pattern, Schema> getPatternProperties() {
        return this.patternProperties.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Pattern, Schema>(Pattern.compile(((Regexp)entry.getKey()).toString()), (Schema)entry.getValue())).collect(Collectors.toMap(entry -> (Pattern)entry.getKey(), entry -> (Schema)entry.getValue()));
    }

    public Map<String, Set<String>> getPropertyDependencies() {
        return this.propertyDependencies;
    }

    public Map<String, Schema> getPropertySchemas() {
        return this.propertySchemas;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public Map<String, Schema> getSchemaDependencies() {
        return this.schemaDependencies;
    }

    public Schema getSchemaOfAdditionalProperties() {
        return this.schemaOfAdditionalProperties;
    }

    public Schema getPropertyNameSchema() {
        return this.propertyNameSchema;
    }

    @Override
    void accept(Visitor visitor) {
        visitor.visitObjectSchema(this);
    }

    public boolean permitsAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean requiresObject() {
        return this.requiresObject;
    }

    boolean hasDefaultProperty() {
        return this.oneOrMoreDefaultProperty;
    }

    @Override
    public boolean definesProperty(String field) {
        String[] headAndTail = this.headAndTailOfJsonPointerFragment(field);
        String nextToken = headAndTail[0];
        String remaining = headAndTail[1];
        field = headAndTail[2];
        return !field.isEmpty() && (this.definesSchemaProperty(nextToken, remaining) || this.definesPatternProperty(nextToken, remaining) || this.definesSchemaDependencyProperty(field));
    }

    private boolean definesSchemaProperty(String current, String remaining) {
        boolean hasSuffix;
        current = JSONPointer.unescape(current);
        boolean bl = hasSuffix = remaining != null;
        if (this.propertySchemas.containsKey(current)) {
            if (hasSuffix) {
                return this.propertySchemas.get(current).definesProperty(remaining);
            }
            return true;
        }
        return false;
    }

    private boolean definesPatternProperty(String current, String remaining) {
        for (Map.Entry<Regexp, Schema> entry : this.patternProperties.entrySet()) {
            Regexp pattern = entry.getKey();
            if (pattern.patternMatchingFailure(current).isPresent() || remaining != null && !entry.getValue().definesProperty(remaining)) continue;
            return true;
        }
        return false;
    }

    private boolean definesSchemaDependencyProperty(String field) {
        if (this.schemaDependencies.containsKey(field)) {
            return true;
        }
        for (Schema schema : this.schemaDependencies.values()) {
            if (!schema.definesProperty(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectSchema) {
            ObjectSchema that = (ObjectSchema)o;
            return that.canEqual(this) && this.additionalProperties == that.additionalProperties && this.requiresObject == that.requiresObject && Objects.equals(this.propertySchemas, that.propertySchemas) && Objects.equals(this.schemaOfAdditionalProperties, that.schemaOfAdditionalProperties) && Objects.equals(this.requiredProperties, that.requiredProperties) && Objects.equals(this.minProperties, that.minProperties) && Objects.equals(this.maxProperties, that.maxProperties) && Objects.equals(this.propertyDependencies, that.propertyDependencies) && Objects.equals(this.schemaDependencies, that.schemaDependencies) && Objects.equals(this.patternProperties, that.patternProperties) && Objects.equals(this.propertyNameSchema, that.propertyNameSchema) && this.oneOrMoreDefaultProperty == that.oneOrMoreDefaultProperty && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertySchemas, this.propertyNameSchema, this.additionalProperties, this.schemaOfAdditionalProperties, this.requiredProperties, this.minProperties, this.maxProperties, this.propertyDependencies, this.schemaDependencies, this.requiresObject, this.patternProperties, this.oneOrMoreDefaultProperty);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectSchema;
    }

    public static class Builder
    extends Schema.Builder<ObjectSchema> {
        private static final RegexpFactory DEFAULT_REGEXP_FACTORY = new JavaUtilRegexpFactory();
        private final Map<Regexp, Schema> patternProperties = new HashMap<Regexp, Schema>();
        private boolean requiresObject = true;
        private final Map<String, Schema> propertySchemas = new HashMap<String, Schema>();
        private boolean additionalProperties = true;
        private Schema schemaOfAdditionalProperties;
        private final List<String> requiredProperties = new ArrayList<String>(0);
        private Integer minProperties;
        private Integer maxProperties;
        private final Map<String, Set<String>> propertyDependencies = new HashMap<String, Set<String>>();
        private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();
        private Schema propertyNameSchema;
        public boolean oneOrMoreDefaultProperty = false;

        private static final Regexp toRegexp(String pattern) {
            return DEFAULT_REGEXP_FACTORY.createHandler(pattern);
        }

        public Builder additionalProperties(boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder addPropertySchema(String propName, Schema schema) {
            Objects.requireNonNull(propName, "propName cannot be null");
            Objects.requireNonNull(schema, "schema cannot be null");
            this.propertySchemas.put(propName, schema);
            this.oneOrMoreDefaultProperty |= schema.hasDefaultValue();
            return this;
        }

        public Builder addRequiredProperty(String propertyName) {
            this.requiredProperties.add(propertyName);
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        @Deprecated
        public Builder patternProperty(Pattern pattern, Schema schema) {
            Regexp handler = Builder.toRegexp(pattern.toString());
            return this.patternProperty(handler, schema);
        }

        @Deprecated
        public Builder patternProperty(String pattern, Schema schema) {
            Regexp handler = Builder.toRegexp(pattern);
            return this.patternProperty(handler, schema);
        }

        public Builder patternProperty(Regexp pattern, Schema schema) {
            this.patternProperties.put(pattern, schema);
            return this;
        }

        public Builder propertyDependency(String ifPresent, String mustBePresent) {
            Set<String> dependencies = this.propertyDependencies.get(ifPresent);
            if (dependencies == null) {
                dependencies = new HashSet<String>(1);
                this.propertyDependencies.put(ifPresent, dependencies);
            }
            dependencies.add(mustBePresent);
            return this;
        }

        public Builder requiresObject(boolean requiresObject) {
            this.requiresObject = requiresObject;
            return this;
        }

        public Builder schemaDependency(String ifPresent, Schema expectedSchema) {
            this.schemaDependencies.put(ifPresent, expectedSchema);
            return this;
        }

        public Builder schemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
            this.schemaOfAdditionalProperties = schemaOfAdditionalProperties;
            return this;
        }

        public Builder propertyNameSchema(Schema propertyNameSchema) {
            this.propertyNameSchema = propertyNameSchema;
            return this;
        }
    }
}

