/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.SortingUtil;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultCollection;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class QueryResultUtils {
    private QueryResultUtils() {
    }

    public static Set transformToSet(SerializationService ss, QueryResult queryResult, Predicate predicate, IterationType iterationType, boolean unique, boolean binary) {
        Predicate unwrappedPredicate = QueryResultUtils.unwrapPartitionPredicate(predicate);
        if (unwrappedPredicate instanceof PagingPredicate) {
            PagingPredicateImpl pagingPredicateImpl;
            PagingPredicate pagingPredicate = (PagingPredicate)unwrappedPredicate;
            if (unwrappedPredicate instanceof PagingPredicateImpl) {
                PagingPredicateImpl impl;
                pagingPredicateImpl = impl = (PagingPredicateImpl)unwrappedPredicate;
            } else {
                Predicate simplePredicate = unwrappedPredicate::apply;
                pagingPredicateImpl = new PagingPredicateImpl(simplePredicate, pagingPredicate.getComparator(), pagingPredicate.getPageSize());
            }
            QueryResultCollection result = new QueryResultCollection(ss, IterationType.ENTRY, binary, unique, queryResult);
            return SortingUtil.getSortedQueryResultSet(new ArrayList<Map.Entry>(result), pagingPredicateImpl, iterationType);
        }
        return new QueryResultCollection(ss, iterationType, binary, unique, queryResult);
    }

    private static <K, V> Predicate<K, V> unwrapPartitionPredicate(Predicate<K, V> predicate) {
        return predicate instanceof PartitionPredicate ? ((PartitionPredicate)predicate).getTarget() : predicate;
    }
}

