/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.journal;

import com.hazelcast.internal.journal.EventJournalInitialSubscriberState;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.map.impl.journal.MapEventJournal;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;

public class MapEventJournalSubscribeOperation
extends MapOperation
implements PartitionAwareOperation,
ReadonlyOperation {
    private EventJournalInitialSubscriberState response;
    private ObjectNamespace namespace;

    public MapEventJournalSubscribeOperation() {
    }

    public MapEventJournalSubscribeOperation(String name) {
        super(name);
    }

    @Override
    protected void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        this.namespace = this.getServiceNamespace();
        if (!this.mapServiceContext.getEventJournal().hasEventJournal(this.namespace)) {
            throw new UnsupportedOperationException("Cannot subscribe to event journal because it is either not configured or disabled for map '" + this.name + "'");
        }
    }

    @Override
    protected void runInternal() {
        MapEventJournal eventJournal = this.mapServiceContext.getEventJournal();
        long newestSequence = eventJournal.newestSequence(this.namespace, this.getPartitionId());
        long oldestSequence = eventJournal.oldestSequence(this.namespace, this.getPartitionId());
        this.response = new EventJournalInitialSubscriberState(oldestSequence, newestSequence);
    }

    @Override
    public EventJournalInitialSubscriberState getResponse() {
        return this.response;
    }

    @Override
    public int getClassId() {
        return 130;
    }
}

