/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.wan.WanMapAddOrUpdateEvent;
import com.hazelcast.map.impl.wan.WanMapRemoveEvent;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.MapMergingEntryImpl;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.Collection;
import java.util.concurrent.CompletionStage;

class WanMapSupportingService
implements WanSupportingService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;
    private final WanEventCounters wanEventTypeCounters;

    WanMapSupportingService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.wanEventTypeCounters = this.nodeEngine.getWanReplicationService().getReceivedEventCounters("hz:impl:mapService");
    }

    @Override
    public void onReplicationEvent(InternalWanEvent event, WanAcknowledgeType acknowledgeType) {
        if (event instanceof WanMapAddOrUpdateEvent) {
            WanMapAddOrUpdateEvent updateEvent = (WanMapAddOrUpdateEvent)event;
            this.handleAddOrUpdate(updateEvent);
        } else if (event instanceof WanMapRemoveEvent) {
            WanMapRemoveEvent removeEvent = (WanMapRemoveEvent)event;
            this.handleRemove(removeEvent);
        }
    }

    @Override
    public CompletionStage<Void> onSyncBatch(Collection<InternalWanEvent> batch, WanAcknowledgeType acknowledgeType) {
        throw new UnsupportedOperationException("WAN Synchronization requires Hazelcast Enterprise Edition");
    }

    @Override
    public void onWanConfigChange() {
    }

    private void handleRemove(WanMapRemoveEvent replicationRemove) {
        String mapName = replicationRemove.getObjectName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        MapOperation operation = operationProvider.createDeleteOperation(replicationRemove.getObjectName(), replicationRemove.getKey(), true);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationRemove.getKey());
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            future.get();
            this.wanEventTypeCounters.incrementRemove(mapName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void handleAddOrUpdate(WanMapAddOrUpdateEvent replicationUpdate) {
        SplitBrainMergePolicy mergePolicy = replicationUpdate.getMergePolicy();
        String mapName = replicationUpdate.getObjectName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(mapName);
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        MapMergingEntryImpl<Object, Object> mergingEntry = MergingValueFactory.createMergingEntry(serializationService, replicationUpdate.getEntryView());
        MapOperation operation = operationProvider.createMergeOperation(mapName, mergingEntry, mergePolicy, true);
        try {
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(replicationUpdate.getEntryView().getKey());
            InvocationFuture future = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            future.get();
            this.wanEventTypeCounters.incrementUpdate(mapName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }
}

