/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.Metric;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyRegistry;
import java.util.Map;
import java.util.stream.Collectors;

class DistributedObjectMetricsProvider
implements MetricsProvider {
    private static final Map<String, Metric[]> SERVICE_NAME_TO_METRIC_NAME = Map.ofEntries(DistributedObjectMetricsProvider.entry("hz:impl:mapService", PhoneHomeMetrics.COUNT_OF_MAPS, PhoneHomeMetrics.COUNT_OF_MAPS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:setService", PhoneHomeMetrics.COUNT_OF_SETS, PhoneHomeMetrics.COUNT_OF_SETS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:queueService", PhoneHomeMetrics.COUNT_OF_QUEUES, PhoneHomeMetrics.COUNT_OF_QUEUES_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:multiMapService", PhoneHomeMetrics.COUNT_OF_MULTIMAPS, PhoneHomeMetrics.COUNT_OF_MULTIMAPS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:listService", PhoneHomeMetrics.COUNT_OF_LISTS, PhoneHomeMetrics.COUNT_OF_LISTS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:ringbufferService", PhoneHomeMetrics.COUNT_OF_RING_BUFFERS, PhoneHomeMetrics.COUNT_OF_RING_BUFFERS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:cacheService", PhoneHomeMetrics.COUNT_OF_CACHES, PhoneHomeMetrics.COUNT_OF_CACHES_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:topicService", PhoneHomeMetrics.COUNT_OF_TOPICS, PhoneHomeMetrics.COUNT_OF_TOPICS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:replicatedMapService", PhoneHomeMetrics.COUNT_OF_REPLICATED_MAPS, PhoneHomeMetrics.COUNT_OF_REPLICATED_MAPS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:cardinalityEstimatorService", PhoneHomeMetrics.COUNT_OF_CARDINALITY_ESTIMATORS, PhoneHomeMetrics.COUNT_OF_CARDINALITY_ESTIMATORS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:PNCounterService", PhoneHomeMetrics.COUNT_OF_PN_COUNTERS, PhoneHomeMetrics.COUNT_OF_PN_COUNTERS_ALL_TIME), DistributedObjectMetricsProvider.entry("hz:impl:flakeIdGeneratorService", PhoneHomeMetrics.COUNT_OF_FLAKE_ID_GENERATORS, PhoneHomeMetrics.COUNT_OF_FLAKE_ID_GENERATORS_ALL_TIME));

    DistributedObjectMetricsProvider() {
    }

    private static Map.Entry<String, Metric[]> entry(String serviceName, Metric count, Metric countOfAllTime) {
        return Map.entry(serviceName, new Metric[]{count, countOfAllTime});
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        InternalProxyService proxyService = node.nodeEngine.getProxyService();
        Map<String, Long> objectsPerService = proxyService.getAllDistributedObjects().stream().filter(obj -> ProxyRegistry.INTERNAL_OBJECTS_PREFIXES.stream().noneMatch(prefix -> obj.getName().startsWith((String)prefix))).filter(obj -> SERVICE_NAME_TO_METRIC_NAME.containsKey(obj.getServiceName())).collect(Collectors.groupingBy(DistributedObject::getServiceName, Collectors.counting()));
        SERVICE_NAME_TO_METRIC_NAME.forEach((serviceName, metrics) -> {
            context.collect(metrics[0], objectsPerService.getOrDefault(serviceName, 0L));
            context.collect(metrics[1], proxyService.getCreatedCount((String)serviceName));
        });
    }
}

