/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;

public final class Sha256Util {
    private Sha256Util() {
    }

    public static String calculateSha256Hex(@Nonnull byte[] data) throws NoSuchAlgorithmException {
        return Sha256Util.calculateSha256Hex(data, data.length);
    }

    public static String calculateSha256Hex(@Nonnull byte[] data, int length) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(data, 0, length);
        byte[] digest = messageDigest.digest();
        return Sha256Util.bytesToHex(digest);
    }

    public static String calculateSha256Hex(@Nonnull Path jarPath) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        try (InputStream inputStream = Files.newInputStream(jarPath, new OpenOption[0]);
             DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);){
            int readCount;
            int oneMB = 0x100000;
            byte[] buffer = new byte[0x100000];
            while ((readCount = digestInputStream.read(buffer)) >= 0) {
            }
        }
        byte[] digest = messageDigest.digest();
        return Sha256Util.bytesToHex(digest);
    }

    public static String bytesToHex(byte[] digest) {
        StringBuilder hexString = new StringBuilder(2 * digest.length);
        int mask = 255;
        for (byte b : digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

