/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberSelector;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionStampUtil;
import com.hazelcast.internal.partition.PartitionStateGenerator;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.ReadonlyInternalPartition;
import com.hazelcast.internal.partition.impl.DefaultPartitionReplicaInterceptor;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.NopPartitionReplicaInterceptor;
import com.hazelcast.internal.partition.impl.PartitionStateGeneratorImpl;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactoryFactory;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.partitiongroup.MemberGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionStateManagerImpl
implements PartitionStateManager {
    private final Node node;
    private final ILogger logger;
    private final InternalPartitionServiceImpl partitionService;
    @Probe(name="partitionCount")
    private final int partitionCount;
    private final InternalPartitionImpl[] partitions;
    private final PartitionStateGenerator partitionStateGenerator;
    private final MemberGroupFactory memberGroupFactory;
    private final ConcurrentMap<UUID, PartitionTableView> snapshotOnRemove;
    private final byte[] stampCalculationBuffer;
    private volatile boolean initialized;
    @Probe(name="stateStamp")
    private volatile long stateStamp = 0L;
    @Probe(name="memberGroupsSize")
    private volatile int memberGroupsSize;
    private PartitionStateManager.ReplicaUpdateInterceptor replicaUpdateInterceptor;

    public PartitionStateManagerImpl(Node node, InternalPartitionServiceImpl partitionService) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        this.partitionService = partitionService;
        this.partitionCount = partitionService.getPartitionCount();
        this.partitions = new InternalPartitionImpl[this.partitionCount];
        this.stampCalculationBuffer = new byte[this.partitionCount * 4];
        DefaultPartitionReplicaInterceptor interceptor = new DefaultPartitionReplicaInterceptor(partitionService);
        PartitionReplica localReplica = PartitionReplica.from(node.getLocalMember());
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partitions[i] = new InternalPartitionImpl(i, localReplica, interceptor);
        }
        this.memberGroupFactory = MemberGroupFactoryFactory.newMemberGroupFactory(node.getConfig().getPartitionGroupConfig(), node.getDiscoveryService());
        this.partitionStateGenerator = new PartitionStateGeneratorImpl();
        this.snapshotOnRemove = new ConcurrentHashMap<UUID, PartitionTableView>();
        this.replicaUpdateInterceptor = NoOpBatchReplicaUpdateInterceptor.INSTANCE;
    }

    @Override
    public boolean hasMigratingPartitions() {
        for (int i = 0; i < this.partitionCount; ++i) {
            if (!this.partitions[i].isMigrating()) continue;
            return true;
        }
        return false;
    }

    @Probe(name="localPartitionCount")
    private int localPartitionCount() {
        int count = 0;
        for (InternalPartitionImpl partition : this.partitions) {
            if (!partition.isLocal()) continue;
            ++count;
        }
        return count;
    }

    @Probe(name="activePartitionCount")
    private int activePartitionCount() {
        return this.partitionService.getMemberPartitionsIfAssigned(this.node.getThisAddress()).size();
    }

    private Collection<MemberGroup> createMemberGroups(Set<Member> excludedMembers) {
        MemberSelector exclude = member -> !excludedMembers.contains(member);
        MemberSelector selector = MemberSelectors.and(MemberSelectors.DATA_MEMBER_SELECTOR, exclude);
        Collection<Member> members = this.node.getClusterService().getMembers(selector);
        return this.memberGroupFactory.createMemberGroups(members);
    }

    private Collection<MemberGroup> createMemberGroups() {
        Collection<Member> members = this.node.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        return this.memberGroupFactory.createMemberGroups(members);
    }

    public Collection<MemberGroup> createMemberGroups(Collection<Member> members) {
        ArrayList<Member> dataMembers = new ArrayList<Member>();
        for (Member member : members) {
            if (!MemberSelectors.DATA_MEMBER_SELECTOR.select(member)) continue;
            dataMembers.add(member);
        }
        return this.memberGroupFactory.createMemberGroups(dataMembers);
    }

    @Override
    public boolean initializePartitionAssignments(Set<Member> excludedMembers) {
        if (!this.isPartitionAssignmentAllowed()) {
            return false;
        }
        Collection<MemberGroup> memberGroups = this.createMemberGroups(excludedMembers);
        if (memberGroups.isEmpty()) {
            this.logger.warning("No member group is available to assign partition ownership...");
            return false;
        }
        this.logger.info("Initializing cluster partition table arrangement...");
        PartitionReplica[][] newState = this.partitionStateGenerator.arrange(memberGroups, this.partitions);
        if (newState.length != this.partitionCount) {
            throw new HazelcastException("Invalid partition count! Expected: " + this.partitionCount + ", Actual: " + newState.length);
        }
        this.batchUpdateReplicas(newState);
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed()) {
            this.reset();
            this.logger.warning("Partitions can't be assigned since cluster-state= " + clusterState);
            return false;
        }
        this.setInitialized();
        return true;
    }

    void batchUpdateReplicas(PartitionReplica[][] newState) {
        PartitionIdSet changedOwnersSet = new PartitionIdSet(this.partitionCount);
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartitionImpl partition = this.partitions[partitionId];
            PartitionReplica[] replicas = newState[partitionId];
            if (!partition.setReplicas(replicas, false)) continue;
            changedOwnersSet.add(partitionId);
        }
        this.partitionOwnersChanged(changedOwnersSet);
    }

    @Override
    public void partitionOwnersChanged(PartitionIdSet partitionIdSet) {
        partitionIdSet.intIterator().forEachRemaining(partitionId -> this.partitionService.getReplicaManager().cancelReplicaSync(partitionId));
        this.updateStamp();
        this.replicaUpdateInterceptor.onPartitionOwnersChanged();
    }

    private boolean isPartitionAssignmentAllowed() {
        if (!this.node.getNodeExtension().isStartCompleted()) {
            this.logger.warning("Partitions can't be assigned since startup is not completed yet.");
            return false;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (!clusterState.isMigrationAllowed()) {
            this.logger.warning("Partitions can't be assigned since cluster-state= " + clusterState);
            return false;
        }
        if (this.partitionService.isFetchMostRecentPartitionTableTaskRequired()) {
            this.logger.warning("Partitions can't be assigned since most recent partition table is not decided yet.");
            return false;
        }
        return true;
    }

    @Override
    public void setInitialState(PartitionTableView partitionTable) {
        if (this.initialized) {
            throw new IllegalStateException("Partition table is already initialized!");
        }
        this.logger.info("Setting cluster partition table...");
        boolean foundReplica = false;
        PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
        PartitionIdSet changedOwnerPartitions = new PartitionIdSet(this.partitionCount);
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartitionImpl partition = this.partitions[partitionId];
            InternalPartition newPartition = partitionTable.getPartition(partitionId);
            if (!foundReplica && newPartition != null) {
                for (int i = 0; i < 7; ++i) {
                    foundReplica |= newPartition.getReplica(i) != null;
                }
            }
            partition.reset(localReplica);
            if (newPartition == null || !partition.setReplicasAndVersion(newPartition)) continue;
            changedOwnerPartitions.add(partitionId);
        }
        if (foundReplica) {
            this.partitionOwnersChanged(changedOwnerPartitions);
            this.setInitialized();
        }
    }

    @Override
    public void updateMemberGroupsSize() {
        Collection<MemberGroup> groups = this.createMemberGroups();
        int size = 0;
        for (MemberGroup group : groups) {
            if (group.size() <= 0) continue;
            ++size;
        }
        this.memberGroupsSize = size;
    }

    @Override
    public int getMemberGroupsSize() {
        int size = this.memberGroupsSize;
        if (size > 0) {
            return size;
        }
        return this.node.isLiteMember() ? 0 : 1;
    }

    @Override
    public void removeUnknownAndLiteMembers() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        for (InternalPartitionImpl partition : this.partitions) {
            for (int i = 0; i < 7; ++i) {
                MemberImpl member;
                PartitionReplica replica = partition.getReplica(i);
                if (replica == null || (member = clusterService.getMember(replica.address(), replica.uuid())) != null && !member.isLiteMember()) continue;
                partition.setReplica(i, null);
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest("PartitionId=" + partition.getPartitionId() + " " + replica + " is removed from replica index: " + i + ", partition: " + partition);
            }
        }
    }

    @Override
    public boolean isAbsentInPartitionTable(Member member) {
        PartitionReplica replica = PartitionReplica.from(member);
        for (InternalPartitionImpl partition : this.partitions) {
            if (!partition.isOwnerOrBackup(replica)) continue;
            return false;
        }
        return true;
    }

    @Override
    public InternalPartition[] getPartitions() {
        return this.partitions;
    }

    @Override
    public InternalPartition[] getPartitionsCopy(boolean readonly) {
        NopPartitionReplicaInterceptor interceptor = new NopPartitionReplicaInterceptor();
        InternalPartition[] result = new InternalPartition[this.partitions.length];
        for (int i = 0; i < this.partitionCount; ++i) {
            result[i] = readonly ? new ReadonlyInternalPartition(this.partitions[i]) : this.partitions[i].copy(interceptor);
        }
        return result;
    }

    @Override
    public InternalPartitionImpl getPartitionImpl(int partitionId) {
        return this.partitions[partitionId];
    }

    @Override
    public PartitionReplica[][] repartition(Set<Member> excludedMembers, Collection<Integer> partitionInclusionSet) {
        if (!this.initialized) {
            return null;
        }
        Collection<MemberGroup> memberGroups = this.createMemberGroups(excludedMembers);
        PartitionReplica[][] newState = this.partitionStateGenerator.arrange(memberGroups, this.partitions, partitionInclusionSet);
        if (newState == null && this.logger.isFinestEnabled()) {
            this.logger.finest("Partition rearrangement failed. Number of member groups: " + memberGroups.size());
        }
        return newState;
    }

    @Override
    public boolean trySetMigratingFlag(int partitionId) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Setting partition-migrating flag. partitionId=" + partitionId);
        }
        return this.partitions[partitionId].setMigrating();
    }

    @Override
    public void clearMigratingFlag(int partitionId) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Clearing partition-migrating flag. partitionId=" + partitionId);
        }
        if (!this.isMigrating(partitionId)) {
            this.logger.warning("Partition " + partitionId + " is not migrating");
        }
        this.partitions[partitionId].resetMigrating();
    }

    @Override
    public boolean isMigrating(int partitionId) {
        return this.partitions[partitionId].isMigrating();
    }

    @Override
    public void updateStamp() {
        this.stateStamp = PartitionStampUtil.calculateStamp(this.partitions, () -> this.stampCalculationBuffer);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("New calculated partition state stamp is: " + this.stateStamp);
        }
        this.replicaUpdateInterceptor.onPartitionStampUpdate();
    }

    @Override
    public long getStamp() {
        return this.stateStamp;
    }

    @Override
    public int getPartitionVersion(int partitionId) {
        return this.partitions[partitionId].version();
    }

    @Override
    public void incrementPartitionVersion(int partitionId, int delta) {
        InternalPartitionImpl partition = this.partitions[partitionId];
        partition.setVersion(partition.version() + delta);
        this.updateStamp();
    }

    @Override
    public boolean setInitialized() {
        if (!this.initialized) {
            assert (this.stateStamp != 0L) : "Partition state stamp should already have been calculated";
            this.initialized = true;
            this.node.getNodeExtension().onPartitionStateChange();
            return true;
        }
        return false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void reset() {
        this.initialized = false;
        this.stateStamp = 0L;
        PartitionReplica localReplica = PartitionReplica.from(this.node.getLocalMember());
        for (InternalPartitionImpl partition : this.partitions) {
            partition.reset(localReplica);
        }
    }

    @Override
    public int replaceMember(Member oldMember, Member newMember) {
        if (!this.initialized) {
            return 0;
        }
        PartitionReplica oldReplica = PartitionReplica.from(oldMember);
        PartitionReplica newReplica = PartitionReplica.from(newMember);
        int count = 0;
        for (InternalPartitionImpl partition : this.partitions) {
            if (partition.replaceReplica(oldReplica, newReplica) <= -1) continue;
            ++count;
        }
        if (count > 0) {
            this.node.getNodeExtension().onPartitionStateChange();
            this.logger.info("Replaced " + oldMember + " with " + newMember + " in partition table in " + count + " partitions.");
        }
        return count;
    }

    @Override
    public PartitionTableView getPartitionTable() {
        return new PartitionTableView(this.getPartitionsCopy(true));
    }

    @Override
    public void storeSnapshot(UUID crashedMemberUuid) {
        this.logger.info("Storing snapshot of partition assignments while removing UUID " + crashedMemberUuid);
        this.snapshotOnRemove.put(crashedMemberUuid, this.getPartitionTable());
    }

    @Override
    public Collection<PartitionTableView> snapshots() {
        return Collections.unmodifiableCollection(this.snapshotOnRemove.values());
    }

    @Override
    public PartitionTableView getSnapshot(UUID crashedMemberUuid) {
        return (PartitionTableView)this.snapshotOnRemove.get(crashedMemberUuid);
    }

    @Override
    public void removeSnapshot(UUID memberUuid) {
        this.snapshotOnRemove.remove(memberUuid);
    }

    @Override
    public void setReplicaUpdateInterceptor(PartitionStateManager.ReplicaUpdateInterceptor interceptor) {
        this.replicaUpdateInterceptor = interceptor;
    }

    static final class NoOpBatchReplicaUpdateInterceptor
    implements PartitionStateManager.ReplicaUpdateInterceptor {
        static final NoOpBatchReplicaUpdateInterceptor INSTANCE = new NoOpBatchReplicaUpdateInterceptor();

        NoOpBatchReplicaUpdateInterceptor() {
        }

        @Override
        public void onPartitionOwnersChanged() {
        }

        @Override
        public void onPartitionStampUpdate() {
        }
    }
}

