/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.AbstractLocalOperation;
import com.hazelcast.version.Version;
import java.util.concurrent.Future;

public class ChangeClusterVersionOperation
extends AbstractLocalOperation {
    private final Version version;

    public ChangeClusterVersionOperation(Version version) {
        this.version = version;
    }

    @Override
    public void run() throws Exception {
        ILogger logger = this.getNodeEngine().getLogger(this.getClass());
        ExecutionService executionService = this.getNodeEngine().getExecutionService();
        Future<Void> future = executionService.submit("hz:async", () -> {
            this.getNodeEngine().getClusterService().changeClusterVersion(this.version);
            return null;
        });
        executionService.asCompletableFuture(future).whenCompleteAsync(ExceptionUtil.withTryCatch(logger, (empty, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : null)), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }
}

