/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import com.hazelcast.dataconnection.DataConnectionResource;
import com.hazelcast.jet.function.TriPredicate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

class ResourceReader {
    private String catalog;
    private TriPredicate<String, String, String> excludePredicate = (catalog, schema, table) -> false;

    ResourceReader() {
    }

    public ResourceReader withCatalog(String schema) {
        this.catalog = schema;
        return this;
    }

    public ResourceReader exclude(TriPredicate<String, String, String> predicate) {
        this.excludePredicate = predicate;
        return this;
    }

    public List<DataConnectionResource> listResources(Connection connection) throws SQLException {
        try (ResultSet tables = connection.getMetaData().getTables(this.catalog, null, null, new String[]{"TABLE", "VIEW"});){
            ArrayList<DataConnectionResource> result = new ArrayList<DataConnectionResource>();
            while (tables.next()) {
                String tableName;
                String schemaName;
                String catalogName = tables.getString("TABLE_CAT");
                if (this.excludePredicate.test(catalogName, schemaName = tables.getString("TABLE_SCHEM"), tableName = tables.getString("TABLE_NAME"))) continue;
                String[] name = (String[])Stream.of(catalogName, schemaName, tableName).filter(Objects::nonNull).toArray(String[]::new);
                result.add(new DataConnectionResource("Table", name));
            }
            ArrayList<DataConnectionResource> arrayList = result;
            return arrayList;
        }
    }
}

